@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.inputs

import com.pulumi.azurenative.networkanalytics.inputs.ManagedResourceGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ManagedResourceGroup related properties
 * @property location Managed Resource Group location
 * @property name Name of managed resource group
 */
public data class ManagedResourceGroupConfigurationArgs(
    public val location: Output<String>,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkanalytics.inputs.ManagedResourceGroupConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkanalytics.inputs.ManagedResourceGroupConfigurationArgs =
        com.pulumi.azurenative.networkanalytics.inputs.ManagedResourceGroupConfigurationArgs.builder()
            .location(location.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedResourceGroupConfigurationArgs].
 */
@PulumiTagMarker
public class ManagedResourceGroupConfigurationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Managed Resource Group location
     */
    @JvmName("ybpntbsyhivjummu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of managed resource group
     */
    @JvmName("cjmlkunjcvtrurnf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Managed Resource Group location
     */
    @JvmName("fmlovbkawxwunpmw")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of managed resource group
     */
    @JvmName("rngcmuqtatebjhcn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ManagedResourceGroupConfigurationArgs =
        ManagedResourceGroupConfigurationArgs(
            location = location ?: throw PulumiNullFieldException("location"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
