@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of Consumption Properties
 * @property fileAccessResourceId Resource Id of file access endpoint.
 * @property fileAccessUrl Url to consume file type.
 * @property ingestionResourceId Resource Id of ingestion endpoint.
 * @property ingestionUrl Ingestion url to upload the data.
 * @property queryResourceId Resource Id of query endpoint.
 * @property queryUrl Url to consume the processed data.
 */
public data class ConsumptionEndpointsPropertiesResponse(
    public val fileAccessResourceId: String,
    public val fileAccessUrl: String,
    public val ingestionResourceId: String,
    public val ingestionUrl: String,
    public val queryResourceId: String,
    public val queryUrl: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkanalytics.outputs.ConsumptionEndpointsPropertiesResponse):
            ConsumptionEndpointsPropertiesResponse = ConsumptionEndpointsPropertiesResponse(
            fileAccessResourceId = javaType.fileAccessResourceId(),
            fileAccessUrl = javaType.fileAccessUrl(),
            ingestionResourceId = javaType.ingestionResourceId(),
            ingestionUrl = javaType.ingestionUrl(),
            queryResourceId = javaType.queryResourceId(),
            queryUrl = javaType.queryUrl(),
        )
    }
}
