@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Data Product Network rule set
 * @property allowedQueryIpRangeList The list of query ips in the format of CIDR allowed to connect to query/visualization endpoint.
 * @property defaultAction Default Action
 * @property ipRules IP rule with specific IP or IP range in CIDR format.
 * @property virtualNetworkRule Virtual Network Rule
 */
public data class DataProductNetworkAclsResponse(
    public val allowedQueryIpRangeList: List<String>,
    public val defaultAction: String,
    public val ipRules: List<IPRulesResponse>,
    public val virtualNetworkRule: List<VirtualNetworkRuleResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkanalytics.outputs.DataProductNetworkAclsResponse):
            DataProductNetworkAclsResponse = DataProductNetworkAclsResponse(
            allowedQueryIpRangeList = javaType.allowedQueryIpRangeList().map({ args0 -> args0 }),
            defaultAction = javaType.defaultAction(),
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkanalytics.kotlin.outputs.IPRulesResponse.Companion.toKotlin(args0)
                })
            }),
            virtualNetworkRule = javaType.virtualNetworkRule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkanalytics.kotlin.outputs.VirtualNetworkRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
