@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP rule with specific IP or IP range in CIDR format.
 * @property action The action of virtual network rule.
 * @property value IP Rules Value
 */
public data class IPRulesResponse(
    public val action: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkanalytics.outputs.IPRulesResponse):
            IPRulesResponse = IPRulesResponse(
            action = javaType.action(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
