@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministratorConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AgentOptionsResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AgentPoolUpgradeSettingsResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AttachedNetworkConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesLabelResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministratorConfigurationResponse.Companion.toKotlin as administratorConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AgentOptionsResponse.Companion.toKotlin as agentOptionsResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AgentPoolUpgradeSettingsResponse.Companion.toKotlin as agentPoolUpgradeSettingsResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AttachedNetworkConfigurationResponse.Companion.toKotlin as attachedNetworkConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesLabelResponse.Companion.toKotlin as kubernetesLabelResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AgentPool].
 */
@PulumiTagMarker
public class AgentPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentPoolArgs = AgentPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentPoolArgsBuilder.() -> Unit) {
        val builder = AgentPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AgentPool {
        val builtJavaResource = com.pulumi.azurenative.networkcloud.AgentPool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AgentPool(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update Kubernetes cluster agent pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.NetworkCloud.AgentPool("agentPool", new()
 *     {
 *         AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *         {
 *             AdminUsername = "azure",
 *             SshPublicKeys = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *             },
 *         },
 *         AgentOptions = new AzureNative.NetworkCloud.Inputs.AgentOptionsArgs
 *         {
 *             HugepagesCount = 96,
 *             HugepagesSize = AzureNative.NetworkCloud.HugepagesSize.HugepagesSize_1G,
 *         },
 *         AgentPoolName = "agentPoolName",
 *         AttachedNetworkConfiguration = new AzureNative.NetworkCloud.Inputs.AttachedNetworkConfigurationArgs
 *         {
 *             L2Networks = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.L2NetworkAttachmentConfigurationArgs
 *                 {
 *                     NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName",
 *                     PluginType = AzureNative.NetworkCloud.KubernetesPluginType.DPDK,
 *                 },
 *             },
 *             L3Networks = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.L3NetworkAttachmentConfigurationArgs
 *                 {
 *                     IpamEnabled = AzureNative.NetworkCloud.L3NetworkConfigurationIpamEnabled.False,
 *                     NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                     PluginType = AzureNative.NetworkCloud.KubernetesPluginType.SRIOV,
 *                 },
 *             },
 *             TrunkedNetworks = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.TrunkedNetworkAttachmentConfigurationArgs
 *                 {
 *                     NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName",
 *                     PluginType = AzureNative.NetworkCloud.KubernetesPluginType.MACVLAN,
 *                 },
 *             },
 *         },
 *         AvailabilityZones = new[]
 *         {
 *             "1",
 *             "2",
 *             "3",
 *         },
 *         Count = 3,
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         KubernetesClusterName = "kubernetesClusterName",
 *         Labels = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *             {
 *                 Key = "kubernetes.label",
 *                 Value = "true",
 *             },
 *         },
 *         Location = "location",
 *         Mode = AzureNative.NetworkCloud.AgentPoolMode.System,
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         Taints = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *             {
 *                 Key = "kubernetes.taint",
 *                 Value = "true",
 *             },
 *         },
 *         UpgradeSettings = new AzureNative.NetworkCloud.Inputs.AgentPoolUpgradeSettingsArgs
 *         {
 *             MaxSurge = "1",
 *         },
 *         VmSkuName = "NC_M16_v1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewAgentPool(ctx, "agentPool", &networkcloud.AgentPoolArgs{
 * 			AdministratorConfiguration: &networkcloud.AdministratorConfigurationArgs{
 * 				AdminUsername: pulumi.String("azure"),
 * 				SshPublicKeys: networkcloud.SshPublicKeyArray{
 * 					&networkcloud.SshPublicKeyArgs{
 * 						KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 					},
 * 				},
 * 			},
 * 			AgentOptions: &networkcloud.AgentOptionsArgs{
 * 				HugepagesCount: pulumi.Float64(96),
 * 				HugepagesSize:  pulumi.String(networkcloud.HugepagesSize_1G),
 * 			},
 * 			AgentPoolName: pulumi.String("agentPoolName"),
 * 			AttachedNetworkConfiguration: &networkcloud.AttachedNetworkConfigurationArgs{
 * 				L2Networks: networkcloud.L2NetworkAttachmentConfigurationArray{
 * 					&networkcloud.L2NetworkAttachmentConfigurationArgs{
 * 						NetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 * 						PluginType: pulumi.String(networkcloud.KubernetesPluginTypeDPDK),
 * 					},
 * 				},
 * 				L3Networks: networkcloud.L3NetworkAttachmentConfigurationArray{
 * 					&networkcloud.L3NetworkAttachmentConfigurationArgs{
 * 						IpamEnabled: pulumi.String(networkcloud.L3NetworkConfigurationIpamEnabledFalse),
 * 						NetworkId:   pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * 						PluginType:  pulumi.String(networkcloud.KubernetesPluginTypeSRIOV),
 * 					},
 * 				},
 * 				TrunkedNetworks: networkcloud.TrunkedNetworkAttachmentConfigurationArray{
 * 					&networkcloud.TrunkedNetworkAttachmentConfigurationArgs{
 * 						NetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 * 						PluginType: pulumi.String(networkcloud.KubernetesPluginTypeMACVLAN),
 * 					},
 * 				},
 * 			},
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 			},
 * 			Count: pulumi.Float64(3),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			KubernetesClusterName: pulumi.String("kubernetesClusterName"),
 * 			Labels: networkcloud.KubernetesLabelArray{
 * 				&networkcloud.KubernetesLabelArgs{
 * 					Key:   pulumi.String("kubernetes.label"),
 * 					Value: pulumi.String("true"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			Mode:              pulumi.String(networkcloud.AgentPoolModeSystem),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			Taints: networkcloud.KubernetesLabelArray{
 * 				&networkcloud.KubernetesLabelArgs{
 * 					Key:   pulumi.String("kubernetes.taint"),
 * 					Value: pulumi.String("true"),
 * 				},
 * 			},
 * 			UpgradeSettings: &networkcloud.AgentPoolUpgradeSettingsArgs{
 * 				MaxSurge: pulumi.String("1"),
 * 			},
 * 			VmSkuName: pulumi.String("NC_M16_v1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.AgentPool;
 * import com.pulumi.azurenative.networkcloud.AgentPoolArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AgentOptionsArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AttachedNetworkConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.KubernetesLabelArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AgentPoolUpgradeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .administratorConfiguration(AdministratorConfigurationArgs.builder()
 *                 .adminUsername("azure")
 *                 .sshPublicKeys(SshPublicKeyArgs.builder()
 *                     .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                     .build())
 *                 .build())
 *             .agentOptions(AgentOptionsArgs.builder()
 *                 .hugepagesCount(96)
 *                 .hugepagesSize("1G")
 *                 .build())
 *             .agentPoolName("agentPoolName")
 *             .attachedNetworkConfiguration(AttachedNetworkConfigurationArgs.builder()
 *                 .l2Networks(L2NetworkAttachmentConfigurationArgs.builder()
 *                     .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName")
 *                     .pluginType("DPDK")
 *                     .build())
 *                 .l3Networks(L3NetworkAttachmentConfigurationArgs.builder()
 *                     .ipamEnabled("False")
 *                     .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName")
 *                     .pluginType("SRIOV")
 *                     .build())
 *                 .trunkedNetworks(TrunkedNetworkAttachmentConfigurationArgs.builder()
 *                     .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName")
 *                     .pluginType("MACVLAN")
 *                     .build())
 *                 .build())
 *             .availabilityZones(
 *                 "1",
 *                 "2",
 *                 "3")
 *             .count(3)
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .kubernetesClusterName("kubernetesClusterName")
 *             .labels(KubernetesLabelArgs.builder()
 *                 .key("kubernetes.label")
 *                 .value("true")
 *                 .build())
 *             .location("location")
 *             .mode("System")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .taints(KubernetesLabelArgs.builder()
 *                 .key("kubernetes.taint")
 *                 .value("true")
 *                 .build())
 *             .upgradeSettings(AgentPoolUpgradeSettingsArgs.builder()
 *                 .maxSurge("1")
 *                 .build())
 *             .vmSkuName("NC_M16_v1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:AgentPool default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}/agentPools/{agentPoolName}
 * ```
 */
public class AgentPool internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.AgentPool,
) : KotlinCustomResource(javaResource, AgentPoolMapper) {
    /**
     * The administrator credentials to be used for the nodes in this agent pool.
     */
    public val administratorConfiguration: Output<AdministratorConfigurationResponse>?
        get() = javaResource.administratorConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> administratorConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The configurations that will be applied to each agent in this agent pool.
     */
    public val agentOptions: Output<AgentOptionsResponse>?
        get() = javaResource.agentOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    agentOptionsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
     */
    public val attachedNetworkConfiguration: Output<AttachedNetworkConfigurationResponse>?
        get() = javaResource.attachedNetworkConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> attachedNetworkConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
     */
    public val availabilityZones: Output<List<String>>?
        get() = javaResource.availabilityZones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The number of virtual machines that use this configuration.
     */
    public val count: Output<Double>
        get() = javaResource.count().applyValue({ args0 -> args0 })

    /**
     * The current status of the agent pool.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Kubernetes version running in this agent pool.
     */
    public val kubernetesVersion: Output<String>
        get() = javaResource.kubernetesVersion().applyValue({ args0 -> args0 })

    /**
     * The labels applied to the nodes in this agent pool.
     */
    public val labels: Output<List<KubernetesLabelResponse>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> kubernetesLabelResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
     */
    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the agent pool.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The taints applied to the nodes in this agent pool.
     */
    public val taints: Output<List<KubernetesLabelResponse>>?
        get() = javaResource.taints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> kubernetesLabelResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The configuration of the agent pool.
     */
    public val upgradeSettings: Output<AgentPoolUpgradeSettingsResponse>?
        get() = javaResource.upgradeSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> agentPoolUpgradeSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the VM SKU that determines the size of resources allocated for node VMs.
     */
    public val vmSkuName: Output<String>
        get() = javaResource.vmSkuName().applyValue({ args0 -> args0 })
}

public object AgentPoolMapper : ResourceMapper<AgentPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.AgentPool::class == javaResource::class

    override fun map(javaResource: Resource): AgentPool = AgentPool(
        javaResource as
            com.pulumi.azurenative.networkcloud.AgentPool,
    )
}

/**
 * @see [AgentPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AgentPool].
 */
public suspend fun agentPool(name: String, block: suspend AgentPoolResourceBuilder.() -> Unit):
    AgentPool {
    val builder = AgentPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AgentPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agentPool(name: String): AgentPool {
    val builder = AgentPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
