@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministrativeCredentialsResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.HardwareInventoryResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.HardwareValidationStatusResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministrativeCredentialsResponse.Companion.toKotlin as administrativeCredentialsResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.HardwareInventoryResponse.Companion.toKotlin as hardwareInventoryResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.HardwareValidationStatusResponse.Companion.toKotlin as hardwareValidationStatusResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [BareMetalMachine].
 */
@PulumiTagMarker
public class BareMetalMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BareMetalMachineArgs = BareMetalMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BareMetalMachineArgsBuilder.() -> Unit) {
        val builder = BareMetalMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BareMetalMachine {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.BareMetalMachine(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BareMetalMachine(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update bare metal machine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bareMetalMachine = new AzureNative.NetworkCloud.BareMetalMachine("bareMetalMachine", new()
 *     {
 *         BareMetalMachineName = "bareMetalMachineName",
 *         BmcConnectionString = "bmcconnectionstring",
 *         BmcCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *         {
 *             Password = "{password}",
 *             Username = "bmcuser",
 *         },
 *         BmcMacAddress = "00:00:4f:00:57:00",
 *         BootMacAddress = "00:00:4e:00:58:af",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         MachineDetails = "User-provided machine details.",
 *         MachineName = "r01c001",
 *         MachineSkuId = "684E-3B16-399E",
 *         RackId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName",
 *         RackSlot = 1,
 *         ResourceGroupName = "resourceGroupName",
 *         SerialNumber = "BM1219XXX",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewBareMetalMachine(ctx, "bareMetalMachine", &networkcloud.BareMetalMachineArgs{
 * 			BareMetalMachineName: pulumi.String("bareMetalMachineName"),
 * 			BmcConnectionString:  pulumi.String("bmcconnectionstring"),
 * 			BmcCredentials: &networkcloud.AdministrativeCredentialsArgs{
 * 				Password: pulumi.String("{password}"),
 * 				Username: pulumi.String("bmcuser"),
 * 			},
 * 			BmcMacAddress:  pulumi.String("00:00:4f:00:57:00"),
 * 			BootMacAddress: pulumi.String("00:00:4e:00:58:af"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			MachineDetails:    pulumi.String("User-provided machine details."),
 * 			MachineName:       pulumi.String("r01c001"),
 * 			MachineSkuId:      pulumi.String("684E-3B16-399E"),
 * 			RackId:            pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
 * 			RackSlot:          pulumi.Float64(1),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SerialNumber:      pulumi.String("BM1219XXX"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.BareMetalMachine;
 * import com.pulumi.azurenative.networkcloud.BareMetalMachineArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AdministrativeCredentialsArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bareMetalMachine = new BareMetalMachine("bareMetalMachine", BareMetalMachineArgs.builder()
 *             .bareMetalMachineName("bareMetalMachineName")
 *             .bmcConnectionString("bmcconnectionstring")
 *             .bmcCredentials(AdministrativeCredentialsArgs.builder()
 *                 .password("{password}")
 *                 .username("bmcuser")
 *                 .build())
 *             .bmcMacAddress("00:00:4f:00:57:00")
 *             .bootMacAddress("00:00:4e:00:58:af")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("location")
 *             .machineDetails("User-provided machine details.")
 *             .machineName("r01c001")
 *             .machineSkuId("684E-3B16-399E")
 *             .rackId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName")
 *             .rackSlot(1)
 *             .resourceGroupName("resourceGroupName")
 *             .serialNumber("BM1219XXX")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:BareMetalMachine bareMetalMachineName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/bareMetalMachines/{bareMetalMachineName}
 * ```
 */
public class BareMetalMachine internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.BareMetalMachine,
) : KotlinCustomResource(javaResource, BareMetalMachineMapper) {
    /**
     * The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
     */
    public val associatedResourceIds: Output<List<String>>
        get() = javaResource.associatedResourceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The connection string for the baseboard management controller including IP address and protocol.
     */
    public val bmcConnectionString: Output<String>
        get() = javaResource.bmcConnectionString().applyValue({ args0 -> args0 })

    /**
     * The credentials of the baseboard management controller on this bare metal machine.
     */
    public val bmcCredentials: Output<AdministrativeCredentialsResponse>
        get() = javaResource.bmcCredentials().applyValue({ args0 ->
            args0.let({ args0 ->
                administrativeCredentialsResponseToKotlin(args0)
            })
        })

    /**
     * The MAC address of the BMC device.
     */
    public val bmcMacAddress: Output<String>
        get() = javaResource.bmcMacAddress().applyValue({ args0 -> args0 })

    /**
     * The MAC address of a NIC connected to the PXE network.
     */
    public val bootMacAddress: Output<String>
        get() = javaResource.bootMacAddress().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the cluster this bare metal machine is associated with.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The cordon status of the bare metal machine.
     */
    public val cordonStatus: Output<String>
        get() = javaResource.cordonStatus().applyValue({ args0 -> args0 })

    /**
     * The more detailed status of the bare metal machine.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The hardware inventory, including information acquired from the model/sku information and from the ironic inspector.
     */
    public val hardwareInventory: Output<HardwareInventoryResponse>
        get() = javaResource.hardwareInventory().applyValue({ args0 ->
            args0.let({ args0 ->
                hardwareInventoryResponseToKotlin(args0)
            })
        })

    /**
     * The details of the latest hardware validation performed for this bare metal machine.
     */
    public val hardwareValidationStatus: Output<HardwareValidationStatusResponse>
        get() = javaResource.hardwareValidationStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                hardwareValidationStatusResponseToKotlin(args0)
            })
        })

    /**
     * Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the HybridAksClusters that have nodes hosted on this bare metal machine.
     */
    public val hybridAksClustersAssociatedIds: Output<List<String>>
        get() = javaResource.hybridAksClustersAssociatedIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The name of this machine represented by the host object in the Cluster's Kubernetes control plane.
     */
    public val kubernetesNodeName: Output<String>
        get() = javaResource.kubernetesNodeName().applyValue({ args0 -> args0 })

    /**
     * The version of Kubernetes running on this machine.
     */
    public val kubernetesVersion: Output<String>
        get() = javaResource.kubernetesVersion().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The custom details provided by the customer.
     */
    public val machineDetails: Output<String>
        get() = javaResource.machineDetails().applyValue({ args0 -> args0 })

    /**
     * The OS-level hostname assigned to this machine.
     */
    public val machineName: Output<String>
        get() = javaResource.machineName().applyValue({ args0 -> args0 })

    /**
     * The unique internal identifier of the bare metal machine SKU.
     */
    public val machineSkuId: Output<String>
        get() = javaResource.machineSkuId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The IPv4 address that is assigned to the bare metal machine during the cluster deployment.
     */
    public val oamIpv4Address: Output<String>
        get() = javaResource.oamIpv4Address().applyValue({ args0 -> args0 })

    /**
     * The IPv6 address that is assigned to the bare metal machine during the cluster deployment.
     */
    public val oamIpv6Address: Output<String>
        get() = javaResource.oamIpv6Address().applyValue({ args0 -> args0 })

    /**
     * The image that is currently provisioned to the OS disk.
     */
    public val osImage: Output<String>
        get() = javaResource.osImage().applyValue({ args0 -> args0 })

    /**
     * The power state derived from the baseboard management controller.
     */
    public val powerState: Output<String>
        get() = javaResource.powerState().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the bare metal machine.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the rack where this bare metal machine resides.
     */
    public val rackId: Output<String>
        get() = javaResource.rackId().applyValue({ args0 -> args0 })

    /**
     * The rack slot in which this bare metal machine is located, ordered from the bottom up i.e. the lowest slot is 1.
     */
    public val rackSlot: Output<Double>
        get() = javaResource.rackSlot().applyValue({ args0 -> args0 })

    /**
     * The indicator of whether the bare metal machine is ready to receive workloads.
     */
    public val readyState: Output<String>
        get() = javaResource.readyState().applyValue({ args0 -> args0 })

    /**
     * The serial number of the bare metal machine.
     */
    public val serialNumber: Output<String>
        get() = javaResource.serialNumber().applyValue({ args0 -> args0 })

    /**
     * The discovered value of the machine's service tag.
     */
    public val serviceTag: Output<String>
        get() = javaResource.serviceTag().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the VirtualMachines that are hosted on this bare metal machine.
     */
    public val virtualMachinesAssociatedIds: Output<List<String>>
        get() = javaResource.virtualMachinesAssociatedIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })
}

public object BareMetalMachineMapper : ResourceMapper<BareMetalMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.BareMetalMachine::class == javaResource::class

    override fun map(javaResource: Resource): BareMetalMachine = BareMetalMachine(
        javaResource as
            com.pulumi.azurenative.networkcloud.BareMetalMachine,
    )
}

/**
 * @see [BareMetalMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BareMetalMachine].
 */
public suspend fun bareMetalMachine(
    name: String,
    block: suspend BareMetalMachineResourceBuilder.() -> Unit,
): BareMetalMachine {
    val builder = BareMetalMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BareMetalMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bareMetalMachine(name: String): BareMetalMachine {
    val builder = BareMetalMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
