@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.EgressEndpointResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.EgressEndpointResponse.Companion.toKotlin as egressEndpointResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CloudServicesNetwork].
 */
@PulumiTagMarker
public class CloudServicesNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudServicesNetworkArgs = CloudServicesNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudServicesNetworkArgsBuilder.() -> Unit) {
        val builder = CloudServicesNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CloudServicesNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.CloudServicesNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CloudServicesNetwork(builtJavaResource)
    }
}

/**
 * Upon creation, the additional services that are provided by the platform will be allocated and
 * represented in the status of this resource. All resources associated with this cloud services network will be part
 * of the same layer 2 (L2) isolation domain. At least one service network must be created but may be reused across many
 * virtual machines and/or Hybrid AKS clusters.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update cloud services network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudServicesNetwork = new AzureNative.NetworkCloud.CloudServicesNetwork("cloudServicesNetwork", new()
 *     {
 *         AdditionalEgressEndpoints = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.EgressEndpointArgs
 *             {
 *                 Category = "azure-resource-management",
 *                 Endpoints = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.EndpointDependencyArgs
 *                     {
 *                         DomainName = "https://storageaccountex.blob.core.windows.net",
 *                         Port = 443,
 *                     },
 *                 },
 *             },
 *         },
 *         CloudServicesNetworkName = "cloudServicesNetworkName",
 *         EnableDefaultEgressEndpoints = AzureNative.NetworkCloud.CloudServicesNetworkEnableDefaultEgressEndpoints.False,
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewCloudServicesNetwork(ctx, "cloudServicesNetwork", &networkcloud.CloudServicesNetworkArgs{
 * 			AdditionalEgressEndpoints: networkcloud.EgressEndpointArray{
 * 				&networkcloud.EgressEndpointArgs{
 * 					Category: pulumi.String("azure-resource-management"),
 * 					Endpoints: networkcloud.EndpointDependencyArray{
 * 						&networkcloud.EndpointDependencyArgs{
 * 							DomainName: pulumi.String("https://storageaccountex.blob.core.windows.net"),
 * 							Port:       pulumi.Float64(443),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			CloudServicesNetworkName:     pulumi.String("cloudServicesNetworkName"),
 * 			EnableDefaultEgressEndpoints: pulumi.String(networkcloud.CloudServicesNetworkEnableDefaultEgressEndpointsFalse),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.CloudServicesNetwork;
 * import com.pulumi.azurenative.networkcloud.CloudServicesNetworkArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.EgressEndpointArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudServicesNetwork = new CloudServicesNetwork("cloudServicesNetwork", CloudServicesNetworkArgs.builder()
 *             .additionalEgressEndpoints(EgressEndpointArgs.builder()
 *                 .category("azure-resource-management")
 *                 .endpoints(EndpointDependencyArgs.builder()
 *                     .domainName("https://storageaccountex.blob.core.windows.net")
 *                     .port(443)
 *                     .build())
 *                 .build())
 *             .cloudServicesNetworkName("cloudServicesNetworkName")
 *             .enableDefaultEgressEndpoints("False")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:CloudServicesNetwork cloudServicesNetworkName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}
 * ```
 */
public class CloudServicesNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.CloudServicesNetwork,
) : KotlinCustomResource(javaResource, CloudServicesNetworkMapper) {
    /**
     * The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
     */
    public val additionalEgressEndpoints: Output<List<EgressEndpointResponse>>?
        get() = javaResource.additionalEgressEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        egressEndpointResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
     */
    public val associatedResourceIds: Output<List<String>>
        get() = javaResource.associatedResourceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The resource ID of the Network Cloud cluster this cloud services network is associated with.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The more detailed status of the cloud services network.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The indicator of whether the platform default endpoints are allowed for the egress traffic.
     */
    public val enableDefaultEgressEndpoints: Output<String>?
        get() = javaResource.enableDefaultEgressEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The full list of additional and default egress endpoints that are currently enabled.
     */
    public val enabledEgressEndpoints: Output<List<EgressEndpointResponse>>
        get() = javaResource.enabledEgressEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> egressEndpointResponseToKotlin(args0) })
            })
        })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource IDs that are associated with this cloud services network.
     */
    public val hybridAksClustersAssociatedIds: Output<List<String>>
        get() = javaResource.hybridAksClustersAssociatedIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The name of the interface that will be present in the virtual machine to represent this network.
     */
    public val interfaceName: Output<String>
        get() = javaResource.interfaceName().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the cloud services network.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are currently using this cloud services network.
     */
    public val virtualMachinesAssociatedIds: Output<List<String>>
        get() = javaResource.virtualMachinesAssociatedIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })
}

public object CloudServicesNetworkMapper : ResourceMapper<CloudServicesNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.CloudServicesNetwork::class == javaResource::class

    override fun map(javaResource: Resource): CloudServicesNetwork = CloudServicesNetwork(
        javaResource
            as com.pulumi.azurenative.networkcloud.CloudServicesNetwork,
    )
}

/**
 * @see [CloudServicesNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudServicesNetwork].
 */
public suspend fun cloudServicesNetwork(
    name: String,
    block: suspend CloudServicesNetworkResourceBuilder.() -> Unit,
): CloudServicesNetwork {
    val builder = CloudServicesNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudServicesNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudServicesNetwork(name: String): CloudServicesNetwork {
    val builder = CloudServicesNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
