@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.CloudServicesNetworkArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.CloudServicesNetworkEnableDefaultEgressEndpoints
import com.pulumi.azurenative.networkcloud.kotlin.inputs.EgressEndpointArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.EgressEndpointArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Upon creation, the additional services that are provided by the platform will be allocated and
 * represented in the status of this resource. All resources associated with this cloud services network will be part
 * of the same layer 2 (L2) isolation domain. At least one service network must be created but may be reused across many
 * virtual machines and/or Hybrid AKS clusters.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update cloud services network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudServicesNetwork = new AzureNative.NetworkCloud.CloudServicesNetwork("cloudServicesNetwork", new()
 *     {
 *         AdditionalEgressEndpoints = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.EgressEndpointArgs
 *             {
 *                 Category = "azure-resource-management",
 *                 Endpoints = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.EndpointDependencyArgs
 *                     {
 *                         DomainName = "https://storageaccountex.blob.core.windows.net",
 *                         Port = 443,
 *                     },
 *                 },
 *             },
 *         },
 *         CloudServicesNetworkName = "cloudServicesNetworkName",
 *         EnableDefaultEgressEndpoints = AzureNative.NetworkCloud.CloudServicesNetworkEnableDefaultEgressEndpoints.False,
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewCloudServicesNetwork(ctx, "cloudServicesNetwork", &networkcloud.CloudServicesNetworkArgs{
 * 			AdditionalEgressEndpoints: networkcloud.EgressEndpointArray{
 * 				&networkcloud.EgressEndpointArgs{
 * 					Category: pulumi.String("azure-resource-management"),
 * 					Endpoints: networkcloud.EndpointDependencyArray{
 * 						&networkcloud.EndpointDependencyArgs{
 * 							DomainName: pulumi.String("https://storageaccountex.blob.core.windows.net"),
 * 							Port:       pulumi.Float64(443),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			CloudServicesNetworkName:     pulumi.String("cloudServicesNetworkName"),
 * 			EnableDefaultEgressEndpoints: pulumi.String(networkcloud.CloudServicesNetworkEnableDefaultEgressEndpointsFalse),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.CloudServicesNetwork;
 * import com.pulumi.azurenative.networkcloud.CloudServicesNetworkArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.EgressEndpointArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudServicesNetwork = new CloudServicesNetwork("cloudServicesNetwork", CloudServicesNetworkArgs.builder()
 *             .additionalEgressEndpoints(EgressEndpointArgs.builder()
 *                 .category("azure-resource-management")
 *                 .endpoints(EndpointDependencyArgs.builder()
 *                     .domainName("https://storageaccountex.blob.core.windows.net")
 *                     .port(443)
 *                     .build())
 *                 .build())
 *             .cloudServicesNetworkName("cloudServicesNetworkName")
 *             .enableDefaultEgressEndpoints("False")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:CloudServicesNetwork cloudServicesNetworkName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}
 * ```
 * @property additionalEgressEndpoints The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
 * @property cloudServicesNetworkName The name of the cloud services network.
 * @property enableDefaultEgressEndpoints The indicator of whether the platform default endpoints are allowed for the egress traffic.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class CloudServicesNetworkArgs(
    public val additionalEgressEndpoints: Output<List<EgressEndpointArgs>>? = null,
    public val cloudServicesNetworkName: Output<String>? = null,
    public val enableDefaultEgressEndpoints:
    Output<Either<String, CloudServicesNetworkEnableDefaultEgressEndpoints>>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.CloudServicesNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.CloudServicesNetworkArgs =
        com.pulumi.azurenative.networkcloud.CloudServicesNetworkArgs.builder()
            .additionalEgressEndpoints(
                additionalEgressEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cloudServicesNetworkName(cloudServicesNetworkName?.applyValue({ args0 -> args0 }))
            .enableDefaultEgressEndpoints(
                enableDefaultEgressEndpoints?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CloudServicesNetworkArgs].
 */
@PulumiTagMarker
public class CloudServicesNetworkArgsBuilder internal constructor() {
    private var additionalEgressEndpoints: Output<List<EgressEndpointArgs>>? = null

    private var cloudServicesNetworkName: Output<String>? = null

    private var enableDefaultEgressEndpoints:
        Output<Either<String, CloudServicesNetworkEnableDefaultEgressEndpoints>>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
     */
    @JvmName("tjythlnleycewivk")
    public suspend fun additionalEgressEndpoints(`value`: Output<List<EgressEndpointArgs>>) {
        this.additionalEgressEndpoints = value
    }

    @JvmName("sukatjwcnqxrrtuv")
    public suspend fun additionalEgressEndpoints(vararg values: Output<EgressEndpointArgs>) {
        this.additionalEgressEndpoints = Output.all(values.asList())
    }

    /**
     * @param values The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
     */
    @JvmName("pxrrhhkhmehloxkp")
    public suspend fun additionalEgressEndpoints(values: List<Output<EgressEndpointArgs>>) {
        this.additionalEgressEndpoints = Output.all(values)
    }

    /**
     * @param value The name of the cloud services network.
     */
    @JvmName("uwborlsrugsamqud")
    public suspend fun cloudServicesNetworkName(`value`: Output<String>) {
        this.cloudServicesNetworkName = value
    }

    /**
     * @param value The indicator of whether the platform default endpoints are allowed for the egress traffic.
     */
    @JvmName("cnxuasecashukllx")
    public suspend
    fun enableDefaultEgressEndpoints(`value`: Output<Either<String, CloudServicesNetworkEnableDefaultEgressEndpoints>>) {
        this.enableDefaultEgressEndpoints = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("dawwqdccjwysekbs")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("egpnmvqnusjbpgpi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ksjonttjgnnrkfyv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("trkrukraeijxwoji")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
     */
    @JvmName("otbrcogecytcmmgq")
    public suspend fun additionalEgressEndpoints(`value`: List<EgressEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalEgressEndpoints = mapped
    }

    /**
     * @param argument The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
     */
    @JvmName("mruktkiavsucleab")
    public suspend
    fun additionalEgressEndpoints(argument: List<suspend EgressEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EgressEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalEgressEndpoints = mapped
    }

    /**
     * @param argument The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
     */
    @JvmName("bgxqkipypdfcckkf")
    public suspend fun additionalEgressEndpoints(
        vararg
        argument: suspend EgressEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EgressEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalEgressEndpoints = mapped
    }

    /**
     * @param argument The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
     */
    @JvmName("oihllvdcbcqfmgrd")
    public suspend
    fun additionalEgressEndpoints(argument: suspend EgressEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EgressEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.additionalEgressEndpoints = mapped
    }

    /**
     * @param values The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
     */
    @JvmName("kflbcygdymtesruu")
    public suspend fun additionalEgressEndpoints(vararg values: EgressEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalEgressEndpoints = mapped
    }

    /**
     * @param value The name of the cloud services network.
     */
    @JvmName("xbfpocvwspfjrvxt")
    public suspend fun cloudServicesNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudServicesNetworkName = mapped
    }

    /**
     * @param value The indicator of whether the platform default endpoints are allowed for the egress traffic.
     */
    @JvmName("uvaluirujctqvhbv")
    public suspend
    fun enableDefaultEgressEndpoints(`value`: Either<String, CloudServicesNetworkEnableDefaultEgressEndpoints>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDefaultEgressEndpoints = mapped
    }

    /**
     * @param value The indicator of whether the platform default endpoints are allowed for the egress traffic.
     */
    @JvmName("hbrfhjukcvbkuchg")
    public fun enableDefaultEgressEndpoints(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CloudServicesNetworkEnableDefaultEgressEndpoints>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableDefaultEgressEndpoints = mapped
    }

    /**
     * @param value The indicator of whether the platform default endpoints are allowed for the egress traffic.
     */
    @JvmName("qdfpfsytmhbbunkl")
    public
    fun enableDefaultEgressEndpoints(`value`: CloudServicesNetworkEnableDefaultEgressEndpoints) {
        val toBeMapped = Either.ofRight<String, CloudServicesNetworkEnableDefaultEgressEndpoints>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableDefaultEgressEndpoints = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("hhshcrqfhixsvgig")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("vythjicedvmncvoo")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("eonakdiypvxkuxfd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("enkpxypdlustlwns")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ucpbdggtrauouaul")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wmicyxbmdglpbuej")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CloudServicesNetworkArgs = CloudServicesNetworkArgs(
        additionalEgressEndpoints = additionalEgressEndpoints,
        cloudServicesNetworkName = cloudServicesNetworkName,
        enableDefaultEgressEndpoints = enableDefaultEgressEndpoints,
        extendedLocation = extendedLocation,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
