@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.ClusterManagerArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ManagedResourceGroupConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ManagedResourceGroupConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update cluster manager
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var clusterManager = new AzureNative.NetworkCloud.ClusterManager("clusterManager", new()
 *     {
 *         AnalyticsWorkspaceId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/microsoft.operationalInsights/workspaces/logAnalyticsWorkspaceName",
 *         ClusterManagerName = "clusterManagerName",
 *         FabricControllerId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName",
 *         Location = "location",
 *         ManagedResourceGroupConfiguration = new AzureNative.NetworkCloud.Inputs.ManagedResourceGroupConfigurationArgs
 *         {
 *             Location = "East US",
 *             Name = "my-managed-rg",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewClusterManager(ctx, "clusterManager", &networkcloud.ClusterManagerArgs{
 * 			AnalyticsWorkspaceId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/microsoft.operationalInsights/workspaces/logAnalyticsWorkspaceName"),
 * 			ClusterManagerName:   pulumi.String("clusterManagerName"),
 * 			FabricControllerId:   pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName"),
 * 			Location:             pulumi.String("location"),
 * 			ManagedResourceGroupConfiguration: &networkcloud.ManagedResourceGroupConfigurationArgs{
 * 				Location: pulumi.String("East US"),
 * 				Name:     pulumi.String("my-managed-rg"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.ClusterManager;
 * import com.pulumi.azurenative.networkcloud.ClusterManagerArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ManagedResourceGroupConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var clusterManager = new ClusterManager("clusterManager", ClusterManagerArgs.builder()
 *             .analyticsWorkspaceId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/microsoft.operationalInsights/workspaces/logAnalyticsWorkspaceName")
 *             .clusterManagerName("clusterManagerName")
 *             .fabricControllerId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName")
 *             .location("location")
 *             .managedResourceGroupConfiguration(ManagedResourceGroupConfigurationArgs.builder()
 *                 .location("East US")
 *                 .name("my-managed-rg")
 *                 .build())
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:ClusterManager clusterManagerName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusterManagers/{clusterManagerName}
 * ```
 * @property analyticsWorkspaceId The resource ID of the Log Analytics workspace that is used for the logs collection.
 * @property availabilityZones Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The Azure availability zones within the region that will be used to support the cluster manager resource.
 * @property clusterManagerName The name of the cluster manager.
 * @property fabricControllerId The resource ID of the fabric controller that has one to one mapping with the cluster manager.
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration The configuration of the managed resource group associated with the resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property vmSize Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The size of the Azure virtual machines to use for hosting the cluster manager resource.
 */
public data class ClusterManagerArgs(
    public val analyticsWorkspaceId: Output<String>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val clusterManagerName: Output<String>? = null,
    public val fabricControllerId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vmSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.ClusterManagerArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.ClusterManagerArgs =
        com.pulumi.azurenative.networkcloud.ClusterManagerArgs.builder()
            .analyticsWorkspaceId(analyticsWorkspaceId?.applyValue({ args0 -> args0 }))
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterManagerName(clusterManagerName?.applyValue({ args0 -> args0 }))
            .fabricControllerId(fabricControllerId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedResourceGroupConfiguration(
                managedResourceGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vmSize(vmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterManagerArgs].
 */
@PulumiTagMarker
public class ClusterManagerArgsBuilder internal constructor() {
    private var analyticsWorkspaceId: Output<String>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var clusterManagerName: Output<String>? = null

    private var fabricControllerId: Output<String>? = null

    private var location: Output<String>? = null

    private var managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vmSize: Output<String>? = null

    /**
     * @param value The resource ID of the Log Analytics workspace that is used for the logs collection.
     */
    @JvmName("cciumhwtgrwliyjm")
    public suspend fun analyticsWorkspaceId(`value`: Output<String>) {
        this.analyticsWorkspaceId = value
    }

    /**
     * @param value Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The Azure availability zones within the region that will be used to support the cluster manager resource.
     */
    @JvmName("sjxtgrysberdecbg")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("fcwoeayxceehujhh")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The Azure availability zones within the region that will be used to support the cluster manager resource.
     */
    @JvmName("noogqqgkyxjvxfqb")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The name of the cluster manager.
     */
    @JvmName("xaxpnqmfmqkmvqaq")
    public suspend fun clusterManagerName(`value`: Output<String>) {
        this.clusterManagerName = value
    }

    /**
     * @param value The resource ID of the fabric controller that has one to one mapping with the cluster manager.
     */
    @JvmName("ihfgjxaibtgesaya")
    public suspend fun fabricControllerId(`value`: Output<String>) {
        this.fabricControllerId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cxrrdtopwhjikgim")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The configuration of the managed resource group associated with the resource.
     */
    @JvmName("tkahedrwulcqnkor")
    public suspend
    fun managedResourceGroupConfiguration(`value`: Output<ManagedResourceGroupConfigurationArgs>) {
        this.managedResourceGroupConfiguration = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pkwijkwhwhnxqwrt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mxkrbiqxfvtvkwol")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The size of the Azure virtual machines to use for hosting the cluster manager resource.
     */
    @JvmName("ooatdpjpbnsbfekc")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value The resource ID of the Log Analytics workspace that is used for the logs collection.
     */
    @JvmName("wfejpvkhlckumvep")
    public suspend fun analyticsWorkspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyticsWorkspaceId = mapped
    }

    /**
     * @param value Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The Azure availability zones within the region that will be used to support the cluster manager resource.
     */
    @JvmName("snhmkyqljkrblody")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The Azure availability zones within the region that will be used to support the cluster manager resource.
     */
    @JvmName("wlspyfrgqxvxjlro")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The name of the cluster manager.
     */
    @JvmName("udhvkmjblispqnja")
    public suspend fun clusterManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterManagerName = mapped
    }

    /**
     * @param value The resource ID of the fabric controller that has one to one mapping with the cluster manager.
     */
    @JvmName("jxppcigwuecsqcuj")
    public suspend fun fabricControllerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricControllerId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("swytohfjlfshkixl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The configuration of the managed resource group associated with the resource.
     */
    @JvmName("bkbdjwjstqtlpsoo")
    public suspend
    fun managedResourceGroupConfiguration(`value`: ManagedResourceGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param argument The configuration of the managed resource group associated with the resource.
     */
    @JvmName("efkjgwegkogvxlid")
    public suspend
    fun managedResourceGroupConfiguration(argument: suspend ManagedResourceGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedResourceGroupConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xkeawtoysdoogeeb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("niewlerwoakdojxc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fjjpblugiwtmimdt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Field deprecated, this value will no longer influence the cluster manager allocation process and will be removed in a future version. The size of the Azure virtual machines to use for hosting the cluster manager resource.
     */
    @JvmName("kloyknpjvimcpyjk")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): ClusterManagerArgs = ClusterManagerArgs(
        analyticsWorkspaceId = analyticsWorkspaceId,
        availabilityZones = availabilityZones,
        clusterManagerName = clusterManagerName,
        fabricControllerId = fabricControllerId,
        location = location,
        managedResourceGroupConfiguration = managedResourceGroupConfiguration,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vmSize = vmSize,
    )
}
