@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SshPublicKeyResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin as sshPublicKeyResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Console].
 */
@PulumiTagMarker
public class ConsoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConsoleArgs = ConsoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConsoleArgsBuilder.() -> Unit) {
        val builder = ConsoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Console {
        val builtJavaResource = com.pulumi.azurenative.networkcloud.Console(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Console(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update virtual machine console
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var console = new AzureNative.NetworkCloud.Console("console", new()
 *     {
 *         ConsoleName = "default",
 *         Enabled = AzureNative.NetworkCloud.ConsoleEnabled.True,
 *         Expiration = "2022-06-01T01:27:03.008Z",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterManagerExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         SshPublicKey = new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *         {
 *             KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *         },
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         VirtualMachineName = "virtualMachineName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewConsole(ctx, "console", &networkcloud.ConsoleArgs{
 * 			ConsoleName: pulumi.String("default"),
 * 			Enabled:     pulumi.String(networkcloud.ConsoleEnabledTrue),
 * 			Expiration:  pulumi.String("2022-06-01T01:27:03.008Z"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterManagerExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SshPublicKey: &networkcloud.SshPublicKeyArgs{
 * 				KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			VirtualMachineName: pulumi.String("virtualMachineName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.Console;
 * import com.pulumi.azurenative.networkcloud.ConsoleArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.SshPublicKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var console = new Console("console", ConsoleArgs.builder()
 *             .consoleName("default")
 *             .enabled("True")
 *             .expiration("2022-06-01T01:27:03.008Z")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterManagerExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .sshPublicKey(SshPublicKeyArgs.builder()
 *                 .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .virtualMachineName("virtualMachineName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:Console default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/virtualMachines/{virtualMachineName}/consoles/{consoleName}
 * ```
 */
public class Console internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.Console,
) : KotlinCustomResource(javaResource, ConsoleMapper) {
    /**
     * The more detailed status of the console.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The indicator of whether the console access is enabled.
     */
    public val enabled: Output<String>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The date and time after which the key will be disallowed access.
     */
    public val expiration: Output<String>?
        get() = javaResource.expiration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extended location of the cluster manager associated with the cluster this virtual machine is created on.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the private link service that is used to provide virtual machine console access.
     */
    public val privateLinkServiceId: Output<String>
        get() = javaResource.privateLinkServiceId().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the virtual machine console.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
     */
    public val sshPublicKey: Output<SshPublicKeyResponse>
        get() = javaResource.sshPublicKey().applyValue({ args0 ->
            args0.let({ args0 ->
                sshPublicKeyResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the virtual machine that is used to access the console.
     */
    public val virtualMachineAccessId: Output<String>
        get() = javaResource.virtualMachineAccessId().applyValue({ args0 -> args0 })
}

public object ConsoleMapper : ResourceMapper<Console> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.Console::class == javaResource::class

    override fun map(javaResource: Resource): Console = Console(
        javaResource as
            com.pulumi.azurenative.networkcloud.Console,
    )
}

/**
 * @see [Console].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Console].
 */
public suspend fun console(name: String, block: suspend ConsoleResourceBuilder.() -> Unit):
    Console {
    val builder = ConsoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Console].
 * @param name The _unique_ name of the resulting resource.
 */
public fun console(name: String): Console {
    val builder = ConsoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
