@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.KubernetesClusterArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AadConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AadConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministratorConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministratorConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ControlPlaneNodeConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ControlPlaneNodeConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.InitialAgentPoolConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.InitialAgentPoolConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ManagedResourceGroupConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ManagedResourceGroupConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.NetworkConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.NetworkConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update Kubernetes cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kubernetesCluster = new AzureNative.NetworkCloud.KubernetesCluster("kubernetesCluster", new()
 *     {
 *         AadConfiguration = new AzureNative.NetworkCloud.Inputs.AadConfigurationArgs
 *         {
 *             AdminGroupObjectIds = new[]
 *             {
 *                 "ffffffff-ffff-ffff-ffff-ffffffffffff",
 *             },
 *         },
 *         AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *         {
 *             AdminUsername = "azure",
 *             SshPublicKeys = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *             },
 *         },
 *         ControlPlaneNodeConfiguration = new AzureNative.NetworkCloud.Inputs.ControlPlaneNodeConfigurationArgs
 *         {
 *             AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *             {
 *                 AdminUsername = "azure",
 *                 SshPublicKeys = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                     {
 *                         KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                     },
 *                 },
 *             },
 *             AvailabilityZones = new[]
 *             {
 *                 "1",
 *                 "2",
 *                 "3",
 *             },
 *             Count = 3,
 *             VmSkuName = "NC_G4_v1",
 *         },
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         InitialAgentPoolConfigurations = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.InitialAgentPoolConfigurationArgs
 *             {
 *                 AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *                 {
 *                     AdminUsername = "azure",
 *                     SshPublicKeys = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                         {
 *                             KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                         },
 *                     },
 *                 },
 *                 AgentOptions = new AzureNative.NetworkCloud.Inputs.AgentOptionsArgs
 *                 {
 *                     HugepagesCount = 96,
 *                     HugepagesSize = AzureNative.NetworkCloud.HugepagesSize.HugepagesSize_1G,
 *                 },
 *                 AttachedNetworkConfiguration = new AzureNative.NetworkCloud.Inputs.AttachedNetworkConfigurationArgs
 *                 {
 *                     L2Networks = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.L2NetworkAttachmentConfigurationArgs
 *                         {
 *                             NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName",
 *                             PluginType = AzureNative.NetworkCloud.KubernetesPluginType.DPDK,
 *                         },
 *                     },
 *                     L3Networks = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.L3NetworkAttachmentConfigurationArgs
 *                         {
 *                             IpamEnabled = AzureNative.NetworkCloud.L3NetworkConfigurationIpamEnabled.False,
 *                             NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                             PluginType = AzureNative.NetworkCloud.KubernetesPluginType.SRIOV,
 *                         },
 *                     },
 *                     TrunkedNetworks = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.TrunkedNetworkAttachmentConfigurationArgs
 *                         {
 *                             NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName",
 *                             PluginType = AzureNative.NetworkCloud.KubernetesPluginType.MACVLAN,
 *                         },
 *                     },
 *                 },
 *                 AvailabilityZones = new[]
 *                 {
 *                     "1",
 *                     "2",
 *                     "3",
 *                 },
 *                 Count = 3,
 *                 Labels = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *                     {
 *                         Key = "kubernetes.label",
 *                         Value = "true",
 *                     },
 *                 },
 *                 Mode = AzureNative.NetworkCloud.AgentPoolMode.System,
 *                 Name = "SystemPool-1",
 *                 Taints = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *                     {
 *                         Key = "kubernetes.taint",
 *                         Value = "true",
 *                     },
 *                 },
 *                 UpgradeSettings = new AzureNative.NetworkCloud.Inputs.AgentPoolUpgradeSettingsArgs
 *                 {
 *                     MaxSurge = "1",
 *                 },
 *                 VmSkuName = "NC_M16_v1",
 *             },
 *         },
 *         KubernetesClusterName = "kubernetesClusterName",
 *         KubernetesVersion = "1.24.12-1",
 *         Location = "location",
 *         ManagedResourceGroupConfiguration = new AzureNative.NetworkCloud.Inputs.ManagedResourceGroupConfigurationArgs
 *         {
 *             Location = "East US",
 *             Name = "my-managed-rg",
 *         },
 *         NetworkConfiguration = new AzureNative.NetworkCloud.Inputs.NetworkConfigurationArgs
 *         {
 *             AttachedNetworkConfiguration = new AzureNative.NetworkCloud.Inputs.AttachedNetworkConfigurationArgs
 *             {
 *                 L2Networks = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.L2NetworkAttachmentConfigurationArgs
 *                     {
 *                         NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName",
 *                         PluginType = AzureNative.NetworkCloud.KubernetesPluginType.DPDK,
 *                     },
 *                 },
 *                 L3Networks = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.L3NetworkAttachmentConfigurationArgs
 *                     {
 *                         IpamEnabled = AzureNative.NetworkCloud.L3NetworkConfigurationIpamEnabled.False,
 *                         NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                         PluginType = AzureNative.NetworkCloud.KubernetesPluginType.SRIOV,
 *                     },
 *                 },
 *                 TrunkedNetworks = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.TrunkedNetworkAttachmentConfigurationArgs
 *                     {
 *                         NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName",
 *                         PluginType = AzureNative.NetworkCloud.KubernetesPluginType.MACVLAN,
 *                     },
 *                 },
 *             },
 *             BgpServiceLoadBalancerConfiguration = new AzureNative.NetworkCloud.Inputs.BgpServiceLoadBalancerConfigurationArgs
 *             {
 *                 BgpAdvertisements = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.BgpAdvertisementArgs
 *                     {
 *                         AdvertiseToFabric = AzureNative.NetworkCloud.AdvertiseToFabric.True,
 *                         Communities = new[]
 *                         {
 *                             "64512:100",
 *                         },
 *                         IpAddressPools = new[]
 *                         {
 *                             "pool1",
 *                         },
 *                         Peers = new[]
 *                         {
 *                             "peer1",
 *                         },
 *                     },
 *                 },
 *                 BgpPeers = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.ServiceLoadBalancerBgpPeerArgs
 *                     {
 *                         BfdEnabled = AzureNative.NetworkCloud.BfdEnabled.False,
 *                         BgpMultiHop = AzureNative.NetworkCloud.BgpMultiHop.False,
 *                         HoldTime = "P300s",
 *                         KeepAliveTime = "P300s",
 *                         MyAsn = 64512,
 *                         Name = "peer1",
 *                         PeerAddress = "203.0.113.254",
 *                         PeerAsn = 64497,
 *                         PeerPort = 179,
 *                     },
 *                 },
 *                 FabricPeeringEnabled = AzureNative.NetworkCloud.FabricPeeringEnabled.True,
 *                 IpAddressPools = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.IpAddressPoolArgs
 *                     {
 *                         Addresses = new[]
 *                         {
 *                             "198.51.102.0/24",
 *                         },
 *                         AutoAssign = AzureNative.NetworkCloud.BfdEnabled.True,
 *                         Name = "pool1",
 *                         OnlyUseHostIps = AzureNative.NetworkCloud.BfdEnabled.True,
 *                     },
 *                 },
 *             },
 *             CloudServicesNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName",
 *             CniNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *             DnsServiceIp = "198.51.101.2",
 *             PodCidrs = new[]
 *             {
 *                 "198.51.100.0/24",
 *             },
 *             ServiceCidrs = new[]
 *             {
 *                 "198.51.101.0/24",
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewKubernetesCluster(ctx, "kubernetesCluster", &networkcloud.KubernetesClusterArgs{
 * 			AadConfiguration: &networkcloud.AadConfigurationArgs{
 * 				AdminGroupObjectIds: pulumi.StringArray{
 * 					pulumi.String("ffffffff-ffff-ffff-ffff-ffffffffffff"),
 * 				},
 * 			},
 * 			AdministratorConfiguration: &networkcloud.AdministratorConfigurationArgs{
 * 				AdminUsername: pulumi.String("azure"),
 * 				SshPublicKeys: networkcloud.SshPublicKeyArray{
 * 					&networkcloud.SshPublicKeyArgs{
 * 						KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 					},
 * 				},
 * 			},
 * 			ControlPlaneNodeConfiguration: &networkcloud.ControlPlaneNodeConfigurationArgs{
 * 				AdministratorConfiguration: &networkcloud.AdministratorConfigurationArgs{
 * 					AdminUsername: pulumi.String("azure"),
 * 					SshPublicKeys: networkcloud.SshPublicKeyArray{
 * 						&networkcloud.SshPublicKeyArgs{
 * 							KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 						},
 * 					},
 * 				},
 * 				AvailabilityZones: pulumi.StringArray{
 * 					pulumi.String("1"),
 * 					pulumi.String("2"),
 * 					pulumi.String("3"),
 * 				},
 * 				Count:     pulumi.Float64(3),
 * 				VmSkuName: pulumi.String("NC_G4_v1"),
 * 			},
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			InitialAgentPoolConfigurations: networkcloud.InitialAgentPoolConfigurationArray{
 * 				&networkcloud.InitialAgentPoolConfigurationArgs{
 * 					AdministratorConfiguration: &networkcloud.AdministratorConfigurationArgs{
 * 						AdminUsername: pulumi.String("azure"),
 * 						SshPublicKeys: networkcloud.SshPublicKeyArray{
 * 							&networkcloud.SshPublicKeyArgs{
 * 								KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 							},
 * 						},
 * 					},
 * 					AgentOptions: &networkcloud.AgentOptionsArgs{
 * 						HugepagesCount: pulumi.Float64(96),
 * 						HugepagesSize:  pulumi.String(networkcloud.HugepagesSize_1G),
 * 					},
 * 					AttachedNetworkConfiguration: &networkcloud.AttachedNetworkConfigurationArgs{
 * 						L2Networks: networkcloud.L2NetworkAttachmentConfigurationArray{
 * 							&networkcloud.L2NetworkAttachmentConfigurationArgs{
 * 								NetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 * 								PluginType: pulumi.String(networkcloud.KubernetesPluginTypeDPDK),
 * 							},
 * 						},
 * 						L3Networks: networkcloud.L3NetworkAttachmentConfigurationArray{
 * 							&networkcloud.L3NetworkAttachmentConfigurationArgs{
 * 								IpamEnabled: pulumi.String(networkcloud.L3NetworkConfigurationIpamEnabledFalse),
 * 								NetworkId:   pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * 								PluginType:  pulumi.String(networkcloud.KubernetesPluginTypeSRIOV),
 * 							},
 * 						},
 * 						TrunkedNetworks: networkcloud.TrunkedNetworkAttachmentConfigurationArray{
 * 							&networkcloud.TrunkedNetworkAttachmentConfigurationArgs{
 * 								NetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 * 								PluginType: pulumi.String(networkcloud.KubernetesPluginTypeMACVLAN),
 * 							},
 * 						},
 * 					},
 * 					AvailabilityZones: pulumi.StringArray{
 * 						pulumi.String("1"),
 * 						pulumi.String("2"),
 * 						pulumi.String("3"),
 * 					},
 * 					Count: pulumi.Float64(3),
 * 					Labels: networkcloud.KubernetesLabelArray{
 * 						&networkcloud.KubernetesLabelArgs{
 * 							Key:   pulumi.String("kubernetes.label"),
 * 							Value: pulumi.String("true"),
 * 						},
 * 					},
 * 					Mode: pulumi.String(networkcloud.AgentPoolModeSystem),
 * 					Name: pulumi.String("SystemPool-1"),
 * 					Taints: networkcloud.KubernetesLabelArray{
 * 						&networkcloud.KubernetesLabelArgs{
 * 							Key:   pulumi.String("kubernetes.taint"),
 * 							Value: pulumi.String("true"),
 * 						},
 * 					},
 * 					UpgradeSettings: &networkcloud.AgentPoolUpgradeSettingsArgs{
 * 						MaxSurge: pulumi.String("1"),
 * 					},
 * 					VmSkuName: pulumi.String("NC_M16_v1"),
 * 				},
 * 			},
 * 			KubernetesClusterName: pulumi.String("kubernetesClusterName"),
 * 			KubernetesVersion:     pulumi.String("1.24.12-1"),
 * 			Location:              pulumi.String("location"),
 * 			ManagedResourceGroupConfiguration: &networkcloud.ManagedResourceGroupConfigurationArgs{
 * 				Location: pulumi.String("East US"),
 * 				Name:     pulumi.String("my-managed-rg"),
 * 			},
 * 			NetworkConfiguration: &networkcloud.NetworkConfigurationArgs{
 * 				AttachedNetworkConfiguration: &networkcloud.AttachedNetworkConfigurationArgs{
 * 					L2Networks: networkcloud.L2NetworkAttachmentConfigurationArray{
 * 						&networkcloud.L2NetworkAttachmentConfigurationArgs{
 * 							NetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 * 							PluginType: pulumi.String(networkcloud.KubernetesPluginTypeDPDK),
 * 						},
 * 					},
 * 					L3Networks: networkcloud.L3NetworkAttachmentConfigurationArray{
 * 						&networkcloud.L3NetworkAttachmentConfigurationArgs{
 * 							IpamEnabled: pulumi.String(networkcloud.L3NetworkConfigurationIpamEnabledFalse),
 * 							NetworkId:   pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * 							PluginType:  pulumi.String(networkcloud.KubernetesPluginTypeSRIOV),
 * 						},
 * 					},
 * 					TrunkedNetworks: networkcloud.TrunkedNetworkAttachmentConfigurationArray{
 * 						&networkcloud.TrunkedNetworkAttachmentConfigurationArgs{
 * 							NetworkId:  pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 * 							PluginType: pulumi.String(networkcloud.KubernetesPluginTypeMACVLAN),
 * 						},
 * 					},
 * 				},
 * 				BgpServiceLoadBalancerConfiguration: &networkcloud.BgpServiceLoadBalancerConfigurationArgs{
 * 					BgpAdvertisements: networkcloud.BgpAdvertisementArray{
 * 						&networkcloud.BgpAdvertisementArgs{
 * 							AdvertiseToFabric: pulumi.String(networkcloud.AdvertiseToFabricTrue),
 * 							Communities: pulumi.StringArray{
 * 								pulumi.String("64512:100"),
 * 							},
 * 							IpAddressPools: pulumi.StringArray{
 * 								pulumi.String("pool1"),
 * 							},
 * 							Peers: pulumi.StringArray{
 * 								pulumi.String("peer1"),
 * 							},
 * 						},
 * 					},
 * 					BgpPeers: networkcloud.ServiceLoadBalancerBgpPeerArray{
 * 						&networkcloud.ServiceLoadBalancerBgpPeerArgs{
 * 							BfdEnabled:    pulumi.String(networkcloud.BfdEnabledFalse),
 * 							BgpMultiHop:   pulumi.String(networkcloud.BgpMultiHopFalse),
 * 							HoldTime:      pulumi.String("P300s"),
 * 							KeepAliveTime: pulumi.String("P300s"),
 * 							MyAsn:         pulumi.Float64(64512),
 * 							Name:          pulumi.String("peer1"),
 * 							PeerAddress:   pulumi.String("203.0.113.254"),
 * 							PeerAsn:       pulumi.Float64(64497),
 * 							PeerPort:      pulumi.Float64(179),
 * 						},
 * 					},
 * 					FabricPeeringEnabled: pulumi.String(networkcloud.FabricPeeringEnabledTrue),
 * 					IpAddressPools: networkcloud.IpAddressPoolArray{
 * 						&networkcloud.IpAddressPoolArgs{
 * 							Addresses: pulumi.StringArray{
 * 								pulumi.String("198.51.102.0/24"),
 * 							},
 * 							AutoAssign:     pulumi.String(networkcloud.BfdEnabledTrue),
 * 							Name:           pulumi.String("pool1"),
 * 							OnlyUseHostIps: pulumi.String(networkcloud.BfdEnabledTrue),
 * 						},
 * 					},
 * 				},
 * 				CloudServicesNetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
 * 				CniNetworkId:           pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * 				DnsServiceIp:           pulumi.String("198.51.101.2"),
 * 				PodCidrs: pulumi.StringArray{
 * 					pulumi.String("198.51.100.0/24"),
 * 				},
 * 				ServiceCidrs: pulumi.StringArray{
 * 					pulumi.String("198.51.101.0/24"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.KubernetesCluster;
 * import com.pulumi.azurenative.networkcloud.KubernetesClusterArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AadConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ControlPlaneNodeConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.InitialAgentPoolConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AgentOptionsArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AttachedNetworkConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.AgentPoolUpgradeSettingsArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ManagedResourceGroupConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.NetworkConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.BgpServiceLoadBalancerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kubernetesCluster = new KubernetesCluster("kubernetesCluster", KubernetesClusterArgs.builder()
 *             .aadConfiguration(AadConfigurationArgs.builder()
 *                 .adminGroupObjectIds("ffffffff-ffff-ffff-ffff-ffffffffffff")
 *                 .build())
 *             .administratorConfiguration(AdministratorConfigurationArgs.builder()
 *                 .adminUsername("azure")
 *                 .sshPublicKeys(SshPublicKeyArgs.builder()
 *                     .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                     .build())
 *                 .build())
 *             .controlPlaneNodeConfiguration(ControlPlaneNodeConfigurationArgs.builder()
 *                 .administratorConfiguration(AdministratorConfigurationArgs.builder()
 *                     .adminUsername("azure")
 *                     .sshPublicKeys(SshPublicKeyArgs.builder()
 *                         .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                         .build())
 *                     .build())
 *                 .availabilityZones(
 *                     "1",
 *                     "2",
 *                     "3")
 *                 .count(3)
 *                 .vmSkuName("NC_G4_v1")
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .initialAgentPoolConfigurations(InitialAgentPoolConfigurationArgs.builder()
 *                 .administratorConfiguration(AdministratorConfigurationArgs.builder()
 *                     .adminUsername("azure")
 *                     .sshPublicKeys(SshPublicKeyArgs.builder()
 *                         .keyData("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm")
 *                         .build())
 *                     .build())
 *                 .agentOptions(AgentOptionsArgs.builder()
 *                     .hugepagesCount(96)
 *                     .hugepagesSize("1G")
 *                     .build())
 *                 .attachedNetworkConfiguration(AttachedNetworkConfigurationArgs.builder()
 *                     .l2Networks(L2NetworkAttachmentConfigurationArgs.builder()
 *                         .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName")
 *                         .pluginType("DPDK")
 *                         .build())
 *                     .l3Networks(L3NetworkAttachmentConfigurationArgs.builder()
 *                         .ipamEnabled("False")
 *                         .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName")
 *                         .pluginType("SRIOV")
 *                         .build())
 *                     .trunkedNetworks(TrunkedNetworkAttachmentConfigurationArgs.builder()
 *                         .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName")
 *                         .pluginType("MACVLAN")
 *                         .build())
 *                     .build())
 *                 .availabilityZones(
 *                     "1",
 *                     "2",
 *                     "3")
 *                 .count(3)
 *                 .labels(KubernetesLabelArgs.builder()
 *                     .key("kubernetes.label")
 *                     .value("true")
 *                     .build())
 *                 .mode("System")
 *                 .name("SystemPool-1")
 *                 .taints(KubernetesLabelArgs.builder()
 *                     .key("kubernetes.taint")
 *                     .value("true")
 *                     .build())
 *                 .upgradeSettings(AgentPoolUpgradeSettingsArgs.builder()
 *                     .maxSurge("1")
 *                     .build())
 *                 .vmSkuName("NC_M16_v1")
 *                 .build())
 *             .kubernetesClusterName("kubernetesClusterName")
 *             .kubernetesVersion("1.24.12-1")
 *             .location("location")
 *             .managedResourceGroupConfiguration(ManagedResourceGroupConfigurationArgs.builder()
 *                 .location("East US")
 *                 .name("my-managed-rg")
 *                 .build())
 *             .networkConfiguration(NetworkConfigurationArgs.builder()
 *                 .attachedNetworkConfiguration(AttachedNetworkConfigurationArgs.builder()
 *                     .l2Networks(L2NetworkAttachmentConfigurationArgs.builder()
 *                         .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName")
 *                         .pluginType("DPDK")
 *                         .build())
 *                     .l3Networks(L3NetworkAttachmentConfigurationArgs.builder()
 *                         .ipamEnabled("False")
 *                         .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName")
 *                         .pluginType("SRIOV")
 *                         .build())
 *                     .trunkedNetworks(TrunkedNetworkAttachmentConfigurationArgs.builder()
 *                         .networkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName")
 *                         .pluginType("MACVLAN")
 *                         .build())
 *                     .build())
 *                 .bgpServiceLoadBalancerConfiguration(BgpServiceLoadBalancerConfigurationArgs.builder()
 *                     .bgpAdvertisements(BgpAdvertisementArgs.builder()
 *                         .advertiseToFabric("True")
 *                         .communities("64512:100")
 *                         .ipAddressPools("pool1")
 *                         .peers("peer1")
 *                         .build())
 *                     .bgpPeers(ServiceLoadBalancerBgpPeerArgs.builder()
 *                         .bfdEnabled("False")
 *                         .bgpMultiHop("False")
 *                         .holdTime("P300s")
 *                         .keepAliveTime("P300s")
 *                         .myAsn(64512)
 *                         .name("peer1")
 *                         .peerAddress("203.0.113.254")
 *                         .peerAsn(64497)
 *                         .peerPort(179)
 *                         .build())
 *                     .fabricPeeringEnabled("True")
 *                     .ipAddressPools(IpAddressPoolArgs.builder()
 *                         .addresses("198.51.102.0/24")
 *                         .autoAssign("True")
 *                         .name("pool1")
 *                         .onlyUseHostIps("True")
 *                         .build())
 *                     .build())
 *                 .cloudServicesNetworkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName")
 *                 .cniNetworkId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName")
 *                 .dnsServiceIp("198.51.101.2")
 *                 .podCidrs("198.51.100.0/24")
 *                 .serviceCidrs("198.51.101.0/24")
 *                 .build())
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:KubernetesCluster KubernetesClusterName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}
 * ```
 * @property aadConfiguration The Azure Active Directory Integration properties.
 * @property administratorConfiguration The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
 * @property controlPlaneNodeConfiguration The defining characteristics of the control plane for this Kubernetes Cluster.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property initialAgentPoolConfigurations The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
 * @property kubernetesClusterName The name of the Kubernetes cluster.
 * @property kubernetesVersion The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used will be resolved into this field after creation or update.
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration The configuration of the managed resource group associated with the resource.
 * @property networkConfiguration The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class KubernetesClusterArgs(
    public val aadConfiguration: Output<AadConfigurationArgs>? = null,
    public val administratorConfiguration: Output<AdministratorConfigurationArgs>? = null,
    public val controlPlaneNodeConfiguration: Output<ControlPlaneNodeConfigurationArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val initialAgentPoolConfigurations: Output<List<InitialAgentPoolConfigurationArgs>>? =
        null,
    public val kubernetesClusterName: Output<String>? = null,
    public val kubernetesVersion: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null,
    public val networkConfiguration: Output<NetworkConfigurationArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.KubernetesClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.KubernetesClusterArgs =
        com.pulumi.azurenative.networkcloud.KubernetesClusterArgs.builder()
            .aadConfiguration(aadConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .administratorConfiguration(
                administratorConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .controlPlaneNodeConfiguration(
                controlPlaneNodeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .initialAgentPoolConfigurations(
                initialAgentPoolConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .kubernetesClusterName(kubernetesClusterName?.applyValue({ args0 -> args0 }))
            .kubernetesVersion(kubernetesVersion?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedResourceGroupConfiguration(
                managedResourceGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KubernetesClusterArgs].
 */
@PulumiTagMarker
public class KubernetesClusterArgsBuilder internal constructor() {
    private var aadConfiguration: Output<AadConfigurationArgs>? = null

    private var administratorConfiguration: Output<AdministratorConfigurationArgs>? = null

    private var controlPlaneNodeConfiguration: Output<ControlPlaneNodeConfigurationArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var initialAgentPoolConfigurations: Output<List<InitialAgentPoolConfigurationArgs>>? =
        null

    private var kubernetesClusterName: Output<String>? = null

    private var kubernetesVersion: Output<String>? = null

    private var location: Output<String>? = null

    private var managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null

    private var networkConfiguration: Output<NetworkConfigurationArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Azure Active Directory Integration properties.
     */
    @JvmName("pxvbkttwtklmrglb")
    public suspend fun aadConfiguration(`value`: Output<AadConfigurationArgs>) {
        this.aadConfiguration = value
    }

    /**
     * @param value The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
     */
    @JvmName("acvbftbneorbobnb")
    public suspend fun administratorConfiguration(`value`: Output<AdministratorConfigurationArgs>) {
        this.administratorConfiguration = value
    }

    /**
     * @param value The defining characteristics of the control plane for this Kubernetes Cluster.
     */
    @JvmName("nteiogirktcbobkg")
    public suspend
    fun controlPlaneNodeConfiguration(`value`: Output<ControlPlaneNodeConfigurationArgs>) {
        this.controlPlaneNodeConfiguration = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("tdnhjjybwtlhtpxh")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("mcgivycqoiygjupl")
    public suspend
    fun initialAgentPoolConfigurations(`value`: Output<List<InitialAgentPoolConfigurationArgs>>) {
        this.initialAgentPoolConfigurations = value
    }

    @JvmName("dcvnhqugclfeaein")
    public suspend fun initialAgentPoolConfigurations(
        vararg
        values: Output<InitialAgentPoolConfigurationArgs>,
    ) {
        this.initialAgentPoolConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("upyqljrimearoooc")
    public suspend
    fun initialAgentPoolConfigurations(values: List<Output<InitialAgentPoolConfigurationArgs>>) {
        this.initialAgentPoolConfigurations = Output.all(values)
    }

    /**
     * @param value The name of the Kubernetes cluster.
     */
    @JvmName("ovcihinfkdsusrwc")
    public suspend fun kubernetesClusterName(`value`: Output<String>) {
        this.kubernetesClusterName = value
    }

    /**
     * @param value The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used will be resolved into this field after creation or update.
     */
    @JvmName("yxidnadeoxqmneti")
    public suspend fun kubernetesVersion(`value`: Output<String>) {
        this.kubernetesVersion = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nlkqwxkpyvjratbm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The configuration of the managed resource group associated with the resource.
     */
    @JvmName("fwmgobrlwrogvaum")
    public suspend
    fun managedResourceGroupConfiguration(`value`: Output<ManagedResourceGroupConfigurationArgs>) {
        this.managedResourceGroupConfiguration = value
    }

    /**
     * @param value The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
     */
    @JvmName("nimflvhrtqaiiiyv")
    public suspend fun networkConfiguration(`value`: Output<NetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("stgeebbouymdswtp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rraiikyhsdxnjtar")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Azure Active Directory Integration properties.
     */
    @JvmName("cbknpohfeytspvoj")
    public suspend fun aadConfiguration(`value`: AadConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadConfiguration = mapped
    }

    /**
     * @param argument The Azure Active Directory Integration properties.
     */
    @JvmName("httbiegwfrlkdamr")
    public suspend fun aadConfiguration(argument: suspend AadConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AadConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aadConfiguration = mapped
    }

    /**
     * @param value The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
     */
    @JvmName("atagqpkrsfcqdnjt")
    public suspend fun administratorConfiguration(`value`: AdministratorConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorConfiguration = mapped
    }

    /**
     * @param argument The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
     */
    @JvmName("swmldtcfpbyyulux")
    public suspend
    fun administratorConfiguration(argument: suspend AdministratorConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AdministratorConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administratorConfiguration = mapped
    }

    /**
     * @param value The defining characteristics of the control plane for this Kubernetes Cluster.
     */
    @JvmName("tyswpbesynupaxme")
    public suspend fun controlPlaneNodeConfiguration(`value`: ControlPlaneNodeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlaneNodeConfiguration = mapped
    }

    /**
     * @param argument The defining characteristics of the control plane for this Kubernetes Cluster.
     */
    @JvmName("jrglwshhxhpisajb")
    public suspend
    fun controlPlaneNodeConfiguration(argument: suspend ControlPlaneNodeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ControlPlaneNodeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.controlPlaneNodeConfiguration = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("axtieaenyqmiefgi")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("etmdmhgmjnkuxnjq")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("xxxfmvuflnfgareu")
    public suspend
    fun initialAgentPoolConfigurations(`value`: List<InitialAgentPoolConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param argument The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("umhhpuyebnupvvba")
    public suspend
    fun initialAgentPoolConfigurations(argument: List<suspend InitialAgentPoolConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InitialAgentPoolConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param argument The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("kdqqinwqtycrfaqf")
    public suspend fun initialAgentPoolConfigurations(
        vararg
        argument: suspend InitialAgentPoolConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InitialAgentPoolConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param argument The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("tnccmfkyigvwybeu")
    public suspend
    fun initialAgentPoolConfigurations(argument: suspend InitialAgentPoolConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InitialAgentPoolConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param values The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    @JvmName("xjvuyppfkyqagiyu")
    public suspend fun initialAgentPoolConfigurations(
        vararg
        values: InitialAgentPoolConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialAgentPoolConfigurations = mapped
    }

    /**
     * @param value The name of the Kubernetes cluster.
     */
    @JvmName("tswqhkujjxwcnuxj")
    public suspend fun kubernetesClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesClusterName = mapped
    }

    /**
     * @param value The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used will be resolved into this field after creation or update.
     */
    @JvmName("xfogxmhdcqjhkpqb")
    public suspend fun kubernetesVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesVersion = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xbdipneaijmtlevg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The configuration of the managed resource group associated with the resource.
     */
    @JvmName("eldunyhmymcqtyxn")
    public suspend
    fun managedResourceGroupConfiguration(`value`: ManagedResourceGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param argument The configuration of the managed resource group associated with the resource.
     */
    @JvmName("vhfldrtqmywnwnni")
    public suspend
    fun managedResourceGroupConfiguration(argument: suspend ManagedResourceGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedResourceGroupConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param value The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
     */
    @JvmName("aikfsuotpxwppqyg")
    public suspend fun networkConfiguration(`value`: NetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
     */
    @JvmName("dubhuxiwoahkuuib")
    public suspend
    fun networkConfiguration(argument: suspend NetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sbnuofrnkujxmvig")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("botcmsvyjmrhtaqe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("sxdxrrkjavhisoaq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KubernetesClusterArgs = KubernetesClusterArgs(
        aadConfiguration = aadConfiguration,
        administratorConfiguration = administratorConfiguration,
        controlPlaneNodeConfiguration = controlPlaneNodeConfiguration,
        extendedLocation = extendedLocation,
        initialAgentPoolConfigurations = initialAgentPoolConfigurations,
        kubernetesClusterName = kubernetesClusterName,
        kubernetesVersion = kubernetesVersion,
        location = location,
        managedResourceGroupConfiguration = managedResourceGroupConfiguration,
        networkConfiguration = networkConfiguration,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
