@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.L2NetworkArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.HybridAksPluginType
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update L2 network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var l2Network = new AzureNative.NetworkCloud.L2Network("l2Network", new()
 *     {
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         HybridAksPluginType = AzureNative.NetworkCloud.HybridAksPluginType.DPDK,
 *         InterfaceName = "eth0",
 *         L2IsolationDomainId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/l2IsolationDomainName",
 *         L2NetworkName = "l2NetworkName",
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewL2Network(ctx, "l2Network", &networkcloud.L2NetworkArgs{
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HybridAksPluginType: pulumi.String(networkcloud.HybridAksPluginTypeDPDK),
 * 			InterfaceName:       pulumi.String("eth0"),
 * 			L2IsolationDomainId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/l2IsolationDomainName"),
 * 			L2NetworkName:       pulumi.String("l2NetworkName"),
 * 			Location:            pulumi.String("location"),
 * 			ResourceGroupName:   pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.L2Network;
 * import com.pulumi.azurenative.networkcloud.L2NetworkArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var l2Network = new L2Network("l2Network", L2NetworkArgs.builder()
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hybridAksPluginType("DPDK")
 *             .interfaceName("eth0")
 *             .l2IsolationDomainId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/l2IsolationDomainName")
 *             .l2NetworkName("l2NetworkName")
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:L2Network l2NetworkName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/l2Networks/{l2NetworkName}
 * ```
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property hybridAksPluginType Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
 * @property interfaceName The default interface name for this L2 network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
 * @property l2IsolationDomainId The resource ID of the Network Fabric l2IsolationDomain.
 * @property l2NetworkName The name of the L2 network.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class L2NetworkArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hybridAksPluginType: Output<Either<String, HybridAksPluginType>>? = null,
    public val interfaceName: Output<String>? = null,
    public val l2IsolationDomainId: Output<String>? = null,
    public val l2NetworkName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.L2NetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.L2NetworkArgs =
        com.pulumi.azurenative.networkcloud.L2NetworkArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hybridAksPluginType(
                hybridAksPluginType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .interfaceName(interfaceName?.applyValue({ args0 -> args0 }))
            .l2IsolationDomainId(l2IsolationDomainId?.applyValue({ args0 -> args0 }))
            .l2NetworkName(l2NetworkName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [L2NetworkArgs].
 */
@PulumiTagMarker
public class L2NetworkArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hybridAksPluginType: Output<Either<String, HybridAksPluginType>>? = null

    private var interfaceName: Output<String>? = null

    private var l2IsolationDomainId: Output<String>? = null

    private var l2NetworkName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("ganrqopyqwietqfx")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("ekxksmkdiwxptedj")
    public suspend fun hybridAksPluginType(`value`: Output<Either<String, HybridAksPluginType>>) {
        this.hybridAksPluginType = value
    }

    /**
     * @param value The default interface name for this L2 network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
     */
    @JvmName("vlbyfmhmgksybifg")
    public suspend fun interfaceName(`value`: Output<String>) {
        this.interfaceName = value
    }

    /**
     * @param value The resource ID of the Network Fabric l2IsolationDomain.
     */
    @JvmName("bxaertungouieicb")
    public suspend fun l2IsolationDomainId(`value`: Output<String>) {
        this.l2IsolationDomainId = value
    }

    /**
     * @param value The name of the L2 network.
     */
    @JvmName("qpuiiqfysjkkxtis")
    public suspend fun l2NetworkName(`value`: Output<String>) {
        this.l2NetworkName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bgtkymmjhpicakyp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vrdighyubtxppjcw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("otteyyyvqcfyqmnn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("tgprclkjlrxtjpgn")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("ajpxagjxqgdgyifx")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("eixvendtngccelih")
    public suspend fun hybridAksPluginType(`value`: Either<String, HybridAksPluginType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridAksPluginType = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("wvnhahrjpaelfiwf")
    public fun hybridAksPluginType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HybridAksPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hybridAksPluginType = mapped
    }

    /**
     * @param value Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    @JvmName("paikcubebgenufky")
    public fun hybridAksPluginType(`value`: HybridAksPluginType) {
        val toBeMapped = Either.ofRight<String, HybridAksPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hybridAksPluginType = mapped
    }

    /**
     * @param value The default interface name for this L2 network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
     */
    @JvmName("hjgvggbisdwborbo")
    public suspend fun interfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interfaceName = mapped
    }

    /**
     * @param value The resource ID of the Network Fabric l2IsolationDomain.
     */
    @JvmName("mbghpxswmrdsijrf")
    public suspend fun l2IsolationDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l2IsolationDomainId = mapped
    }

    /**
     * @param value The name of the L2 network.
     */
    @JvmName("dybpqojeeadtehhb")
    public suspend fun l2NetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l2NetworkName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fvcsphqoecqvgewc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yirimekkpjrqideq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wccbwuookqlimjvm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nknllspqwmlcnlgc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): L2NetworkArgs = L2NetworkArgs(
        extendedLocation = extendedLocation,
        hybridAksPluginType = hybridAksPluginType,
        interfaceName = interfaceName,
        l2IsolationDomainId = l2IsolationDomainId,
        l2NetworkName = l2NetworkName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
