@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MetricsConfiguration].
 */
@PulumiTagMarker
public class MetricsConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetricsConfigurationArgs = MetricsConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetricsConfigurationArgsBuilder.() -> Unit) {
        val builder = MetricsConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MetricsConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.MetricsConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MetricsConfiguration(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update metrics configuration of cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricsConfiguration = new AzureNative.NetworkCloud.MetricsConfiguration("metricsConfiguration", new()
 *     {
 *         ClusterName = "clusterName",
 *         CollectionInterval = 15,
 *         EnabledMetrics = new[]
 *         {
 *             "metric1",
 *             "metric2",
 *         },
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         MetricsConfigurationName = "default",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewMetricsConfiguration(ctx, "metricsConfiguration", &networkcloud.MetricsConfigurationArgs{
 * 			ClusterName:        pulumi.String("clusterName"),
 * 			CollectionInterval: pulumi.Float64(15),
 * 			EnabledMetrics: pulumi.StringArray{
 * 				pulumi.String("metric1"),
 * 				pulumi.String("metric2"),
 * 			},
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:                 pulumi.String("location"),
 * 			MetricsConfigurationName: pulumi.String("default"),
 * 			ResourceGroupName:        pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.MetricsConfiguration;
 * import com.pulumi.azurenative.networkcloud.MetricsConfigurationArgs;
 * import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricsConfiguration = new MetricsConfiguration("metricsConfiguration", MetricsConfigurationArgs.builder()
 *             .clusterName("clusterName")
 *             .collectionInterval(15)
 *             .enabledMetrics(
 *                 "metric1",
 *                 "metric2")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("location")
 *             .metricsConfigurationName("default")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:MetricsConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}
 * ```
 */
public class MetricsConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.MetricsConfiguration,
) : KotlinCustomResource(javaResource, MetricsConfigurationMapper) {
    /**
     * The interval in minutes by which metrics will be collected.
     */
    public val collectionInterval: Output<Double>
        get() = javaResource.collectionInterval().applyValue({ args0 -> args0 })

    /**
     * The more detailed status of the metrics configuration.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The list of metrics that are available for the cluster but disabled at the moment.
     */
    public val disabledMetrics: Output<List<String>>
        get() = javaResource.disabledMetrics().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The list of metric names that have been chosen to be enabled in addition to the core set of enabled metrics.
     */
    public val enabledMetrics: Output<List<String>>?
        get() = javaResource.enabledMetrics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the metrics configuration.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MetricsConfigurationMapper : ResourceMapper<MetricsConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.MetricsConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): MetricsConfiguration = MetricsConfiguration(
        javaResource
            as com.pulumi.azurenative.networkcloud.MetricsConfiguration,
    )
}

/**
 * @see [MetricsConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetricsConfiguration].
 */
public suspend fun metricsConfiguration(
    name: String,
    block: suspend MetricsConfigurationResourceBuilder.() -> Unit,
): MetricsConfiguration {
    val builder = MetricsConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetricsConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metricsConfiguration(name: String): MetricsConfiguration {
    val builder = MetricsConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
