@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property adminUsername The user name for the administrator that will be applied to the operating systems that run Kubernetes nodes. If not supplied, a user name will be chosen by the service.
 * @property sshPublicKeys The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
 */
public data class AdministratorConfigurationArgs(
    public val adminUsername: Output<String>? = null,
    public val sshPublicKeys: Output<List<SshPublicKeyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.AdministratorConfigurationArgs.builder()
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .sshPublicKeys(
                sshPublicKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AdministratorConfigurationArgs].
 */
@PulumiTagMarker
public class AdministratorConfigurationArgsBuilder internal constructor() {
    private var adminUsername: Output<String>? = null

    private var sshPublicKeys: Output<List<SshPublicKeyArgs>>? = null

    /**
     * @param value The user name for the administrator that will be applied to the operating systems that run Kubernetes nodes. If not supplied, a user name will be chosen by the service.
     */
    @JvmName("vqfipsqbqwjvggbh")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("vpoamxoxygxtvfso")
    public suspend fun sshPublicKeys(`value`: Output<List<SshPublicKeyArgs>>) {
        this.sshPublicKeys = value
    }

    @JvmName("ofausrdisduijndn")
    public suspend fun sshPublicKeys(vararg values: Output<SshPublicKeyArgs>) {
        this.sshPublicKeys = Output.all(values.asList())
    }

    /**
     * @param values The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("hbjqofiuqeimljav")
    public suspend fun sshPublicKeys(values: List<Output<SshPublicKeyArgs>>) {
        this.sshPublicKeys = Output.all(values)
    }

    /**
     * @param value The user name for the administrator that will be applied to the operating systems that run Kubernetes nodes. If not supplied, a user name will be chosen by the service.
     */
    @JvmName("qbbbdyqrqnfkbbvx")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("qgdheeipplyrnlny")
    public suspend fun sshPublicKeys(`value`: List<SshPublicKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPublicKeys = mapped
    }

    /**
     * @param argument The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("ohdpmbyymmvonctx")
    public suspend fun sshPublicKeys(argument: List<suspend SshPublicKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sshPublicKeys = mapped
    }

    /**
     * @param argument The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("siwpmtdvuwmavjhj")
    public suspend fun sshPublicKeys(vararg argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sshPublicKeys = mapped
    }

    /**
     * @param argument The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("cjqsfwlomtchswdn")
    public suspend fun sshPublicKeys(argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SshPublicKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sshPublicKeys = mapped
    }

    /**
     * @param values The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
     */
    @JvmName("mfbqubbidjttukhq")
    public suspend fun sshPublicKeys(vararg values: SshPublicKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshPublicKeys = mapped
    }

    internal fun build(): AdministratorConfigurationArgs = AdministratorConfigurationArgs(
        adminUsername = adminUsername,
        sshPublicKeys = sshPublicKeys,
    )
}
