@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.BareMetalMachineConfigurationDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bmcCredentials The credentials of the baseboard management controller on this bare metal machine.
 * @property bmcMacAddress The MAC address of the BMC for this machine.
 * @property bootMacAddress The MAC address associated with the PXE NIC card.
 * @property machineDetails The free-form additional information about the machine, e.g. an asset tag.
 * @property machineName The user-provided name for the bare metal machine created from this specification.
 * If not provided, the machine name will be generated programmatically.
 * @property rackSlot The slot the physical machine is in the rack based on the BOM configuration.
 * @property serialNumber The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag.
 */
public data class BareMetalMachineConfigurationDataArgs(
    public val bmcCredentials: Output<AdministrativeCredentialsArgs>,
    public val bmcMacAddress: Output<String>,
    public val bootMacAddress: Output<String>,
    public val machineDetails: Output<String>? = null,
    public val machineName: Output<String>? = null,
    public val rackSlot: Output<Double>,
    public val serialNumber: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.BareMetalMachineConfigurationDataArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkcloud.inputs.BareMetalMachineConfigurationDataArgs =
        com.pulumi.azurenative.networkcloud.inputs.BareMetalMachineConfigurationDataArgs.builder()
            .bmcCredentials(bmcCredentials.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .bmcMacAddress(bmcMacAddress.applyValue({ args0 -> args0 }))
            .bootMacAddress(bootMacAddress.applyValue({ args0 -> args0 }))
            .machineDetails(machineDetails?.applyValue({ args0 -> args0 }))
            .machineName(machineName?.applyValue({ args0 -> args0 }))
            .rackSlot(rackSlot.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BareMetalMachineConfigurationDataArgs].
 */
@PulumiTagMarker
public class BareMetalMachineConfigurationDataArgsBuilder internal constructor() {
    private var bmcCredentials: Output<AdministrativeCredentialsArgs>? = null

    private var bmcMacAddress: Output<String>? = null

    private var bootMacAddress: Output<String>? = null

    private var machineDetails: Output<String>? = null

    private var machineName: Output<String>? = null

    private var rackSlot: Output<Double>? = null

    private var serialNumber: Output<String>? = null

    /**
     * @param value The credentials of the baseboard management controller on this bare metal machine.
     */
    @JvmName("iumrbayhavaqyvqu")
    public suspend fun bmcCredentials(`value`: Output<AdministrativeCredentialsArgs>) {
        this.bmcCredentials = value
    }

    /**
     * @param value The MAC address of the BMC for this machine.
     */
    @JvmName("cerlgxwebitxkaxx")
    public suspend fun bmcMacAddress(`value`: Output<String>) {
        this.bmcMacAddress = value
    }

    /**
     * @param value The MAC address associated with the PXE NIC card.
     */
    @JvmName("mjrmxaulaspeupbw")
    public suspend fun bootMacAddress(`value`: Output<String>) {
        this.bootMacAddress = value
    }

    /**
     * @param value The free-form additional information about the machine, e.g. an asset tag.
     */
    @JvmName("swshfarvfblnckjh")
    public suspend fun machineDetails(`value`: Output<String>) {
        this.machineDetails = value
    }

    /**
     * @param value The user-provided name for the bare metal machine created from this specification.
     * If not provided, the machine name will be generated programmatically.
     */
    @JvmName("nfasteaayetwsasq")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value The slot the physical machine is in the rack based on the BOM configuration.
     */
    @JvmName("qepklhkluftiudsl")
    public suspend fun rackSlot(`value`: Output<Double>) {
        this.rackSlot = value
    }

    /**
     * @param value The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag.
     */
    @JvmName("evvdjxhjwidtdrfi")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value The credentials of the baseboard management controller on this bare metal machine.
     */
    @JvmName("ijgqllsvtjjxnmso")
    public suspend fun bmcCredentials(`value`: AdministrativeCredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bmcCredentials = mapped
    }

    /**
     * @param argument The credentials of the baseboard management controller on this bare metal machine.
     */
    @JvmName("cjvvuccuuodqwtge")
    public suspend
    fun bmcCredentials(argument: suspend AdministrativeCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = AdministrativeCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bmcCredentials = mapped
    }

    /**
     * @param value The MAC address of the BMC for this machine.
     */
    @JvmName("kjtkrrmrtrlmrndc")
    public suspend fun bmcMacAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bmcMacAddress = mapped
    }

    /**
     * @param value The MAC address associated with the PXE NIC card.
     */
    @JvmName("xcstayfawuagvrtp")
    public suspend fun bootMacAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bootMacAddress = mapped
    }

    /**
     * @param value The free-form additional information about the machine, e.g. an asset tag.
     */
    @JvmName("csjevxlpaxxsfgkw")
    public suspend fun machineDetails(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineDetails = mapped
    }

    /**
     * @param value The user-provided name for the bare metal machine created from this specification.
     * If not provided, the machine name will be generated programmatically.
     */
    @JvmName("gkmsacoglhruakxf")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value The slot the physical machine is in the rack based on the BOM configuration.
     */
    @JvmName("bjymkmfcpnvimoaf")
    public suspend fun rackSlot(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rackSlot = mapped
    }

    /**
     * @param value The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag.
     */
    @JvmName("uerhfgclqvrdjebp")
    public suspend fun serialNumber(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    internal fun build(): BareMetalMachineConfigurationDataArgs =
        BareMetalMachineConfigurationDataArgs(
            bmcCredentials = bmcCredentials ?: throw PulumiNullFieldException("bmcCredentials"),
            bmcMacAddress = bmcMacAddress ?: throw PulumiNullFieldException("bmcMacAddress"),
            bootMacAddress = bootMacAddress ?: throw PulumiNullFieldException("bootMacAddress"),
            machineDetails = machineDetails,
            machineName = machineName,
            rackSlot = rackSlot ?: throw PulumiNullFieldException("rackSlot"),
            serialNumber = serialNumber ?: throw PulumiNullFieldException("serialNumber"),
        )
}
