@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The resource ID of the extended location on which the resource will be created.
 * @property type The extended location type, for example, CustomLocation.
 */
public data class ExtendedLocationArgs(
    public val name: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs =
        com.pulumi.azurenative.networkcloud.inputs.ExtendedLocationArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtendedLocationArgs].
 */
@PulumiTagMarker
public class ExtendedLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The resource ID of the extended location on which the resource will be created.
     */
    @JvmName("iyvjvqofrkwdjloo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The extended location type, for example, CustomLocation.
     */
    @JvmName("dmrvhjkwyoajquwc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The resource ID of the extended location on which the resource will be created.
     */
    @JvmName("njkhyiyjjabpjgjq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The extended location type, for example, CustomLocation.
     */
    @JvmName("dcxujhtpdiiungfj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExtendedLocationArgs = ExtendedLocationArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
