@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetAgentPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property agentPoolName The name of the Kubernetes cluster agent pool.
 * @property kubernetesClusterName The name of the Kubernetes cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAgentPoolPlainArgs(
    public val agentPoolName: String,
    public val kubernetesClusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetAgentPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetAgentPoolPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetAgentPoolPlainArgs.builder()
            .agentPoolName(agentPoolName.let({ args0 -> args0 }))
            .kubernetesClusterName(kubernetesClusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAgentPoolPlainArgs].
 */
@PulumiTagMarker
public class GetAgentPoolPlainArgsBuilder internal constructor() {
    private var agentPoolName: String? = null

    private var kubernetesClusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kubernetes cluster agent pool.
     */
    @JvmName("gnlhdnkjpjckbcyw")
    public suspend fun agentPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.agentPoolName = mapped
    }

    /**
     * @param value The name of the Kubernetes cluster.
     */
    @JvmName("poswywgbnxoqddoa")
    public suspend fun kubernetesClusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kubernetesClusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jbyxiolcnttmywth")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAgentPoolPlainArgs = GetAgentPoolPlainArgs(
        agentPoolName = agentPoolName ?: throw PulumiNullFieldException("agentPoolName"),
        kubernetesClusterName = kubernetesClusterName ?: throw
            PulumiNullFieldException("kubernetesClusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
