@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetConsolePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property consoleName The name of the virtual machine console.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property virtualMachineName The name of the virtual machine.
 */
public data class GetConsolePlainArgs(
    public val consoleName: String,
    public val resourceGroupName: String,
    public val virtualMachineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetConsolePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetConsolePlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetConsolePlainArgs.builder()
            .consoleName(consoleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConsolePlainArgs].
 */
@PulumiTagMarker
public class GetConsolePlainArgsBuilder internal constructor() {
    private var consoleName: String? = null

    private var resourceGroupName: String? = null

    private var virtualMachineName: String? = null

    /**
     * @param value The name of the virtual machine console.
     */
    @JvmName("yegqhyawfmqsnsjk")
    public suspend fun consoleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.consoleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mlmxcqslalmevpib")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("iclgcyvainfogmrr")
    public suspend fun virtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualMachineName = mapped
    }

    internal fun build(): GetConsolePlainArgs = GetConsolePlainArgs(
        consoleName = consoleName ?: throw PulumiNullFieldException("consoleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualMachineName = virtualMachineName ?: throw PulumiNullFieldException("virtualMachineName"),
    )
}
