@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.ImageRepositoryCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password The password or token used to access an image in the target repository.
 * @property registryUrl The URL of the authentication server used to validate the repository credentials.
 * @property username The username used to access an image in the target repository.
 */
public data class ImageRepositoryCredentialsArgs(
    public val password: Output<String>,
    public val registryUrl: Output<String>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.ImageRepositoryCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.ImageRepositoryCredentialsArgs =
        com.pulumi.azurenative.networkcloud.inputs.ImageRepositoryCredentialsArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .registryUrl(registryUrl.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageRepositoryCredentialsArgs].
 */
@PulumiTagMarker
public class ImageRepositoryCredentialsArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var registryUrl: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password or token used to access an image in the target repository.
     */
    @JvmName("lrkdvmkinfdhvbhh")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The URL of the authentication server used to validate the repository credentials.
     */
    @JvmName("fhutoctctoujrnuh")
    public suspend fun registryUrl(`value`: Output<String>) {
        this.registryUrl = value
    }

    /**
     * @param value The username used to access an image in the target repository.
     */
    @JvmName("hftjgiqebhcppchr")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password or token used to access an image in the target repository.
     */
    @JvmName("dhawpnuxfyffyjfm")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The URL of the authentication server used to validate the repository credentials.
     */
    @JvmName("nfyioosjelqphagr")
    public suspend fun registryUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registryUrl = mapped
    }

    /**
     * @param value The username used to access an image in the target repository.
     */
    @JvmName("wfroeupqocylqrsk")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ImageRepositoryCredentialsArgs = ImageRepositoryCredentialsArgs(
        password = password ?: throw PulumiNullFieldException("password"),
        registryUrl = registryUrl ?: throw PulumiNullFieldException("registryUrl"),
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
