@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.InitialAgentPoolConfigurationArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.AgentPoolMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property administratorConfiguration The administrator credentials to be used for the nodes in this agent pool.
 * @property agentOptions The configurations that will be applied to each agent in this agent pool.
 * @property attachedNetworkConfiguration The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
 * @property availabilityZones The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
 * @property count The number of virtual machines that use this configuration.
 * @property labels The labels applied to the nodes in this agent pool.
 * @property mode The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
 * @property name The name that will be used for the agent pool resource representing this agent pool.
 * @property taints The taints applied to the nodes in this agent pool.
 * @property upgradeSettings The configuration of the agent pool.
 * @property vmSkuName The name of the VM SKU that determines the size of resources allocated for node VMs.
 */
public data class InitialAgentPoolConfigurationArgs(
    public val administratorConfiguration: Output<AdministratorConfigurationArgs>? = null,
    public val agentOptions: Output<AgentOptionsArgs>? = null,
    public val attachedNetworkConfiguration: Output<AttachedNetworkConfigurationArgs>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val count: Output<Double>,
    public val labels: Output<List<KubernetesLabelArgs>>? = null,
    public val mode: Output<Either<String, AgentPoolMode>>,
    public val name: Output<String>,
    public val taints: Output<List<KubernetesLabelArgs>>? = null,
    public val upgradeSettings: Output<AgentPoolUpgradeSettingsArgs>? = null,
    public val vmSkuName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.InitialAgentPoolConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkcloud.inputs.InitialAgentPoolConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.InitialAgentPoolConfigurationArgs.builder()
            .administratorConfiguration(
                administratorConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .agentOptions(agentOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .attachedNetworkConfiguration(
                attachedNetworkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .count(count.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .mode(
                mode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .taints(taints?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .upgradeSettings(upgradeSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmSkuName(vmSkuName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InitialAgentPoolConfigurationArgs].
 */
@PulumiTagMarker
public class InitialAgentPoolConfigurationArgsBuilder internal constructor() {
    private var administratorConfiguration: Output<AdministratorConfigurationArgs>? = null

    private var agentOptions: Output<AgentOptionsArgs>? = null

    private var attachedNetworkConfiguration: Output<AttachedNetworkConfigurationArgs>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var count: Output<Double>? = null

    private var labels: Output<List<KubernetesLabelArgs>>? = null

    private var mode: Output<Either<String, AgentPoolMode>>? = null

    private var name: Output<String>? = null

    private var taints: Output<List<KubernetesLabelArgs>>? = null

    private var upgradeSettings: Output<AgentPoolUpgradeSettingsArgs>? = null

    private var vmSkuName: Output<String>? = null

    /**
     * @param value The administrator credentials to be used for the nodes in this agent pool.
     */
    @JvmName("kdowhaqlxvbbklar")
    public suspend fun administratorConfiguration(`value`: Output<AdministratorConfigurationArgs>) {
        this.administratorConfiguration = value
    }

    /**
     * @param value The configurations that will be applied to each agent in this agent pool.
     */
    @JvmName("eniwkpwgwcelvaga")
    public suspend fun agentOptions(`value`: Output<AgentOptionsArgs>) {
        this.agentOptions = value
    }

    /**
     * @param value The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
     */
    @JvmName("oljuwyjljrytulub")
    public suspend
    fun attachedNetworkConfiguration(`value`: Output<AttachedNetworkConfigurationArgs>) {
        this.attachedNetworkConfiguration = value
    }

    /**
     * @param value The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
     */
    @JvmName("exiakrafpjwtguhl")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("uprgjvydbulxudho")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
     */
    @JvmName("qdyfmarrceayymve")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The number of virtual machines that use this configuration.
     */
    @JvmName("whlslivtjvwdvrli")
    public suspend fun count(`value`: Output<Double>) {
        this.count = value
    }

    /**
     * @param value The labels applied to the nodes in this agent pool.
     */
    @JvmName("dpditpbkaglslycn")
    public suspend fun labels(`value`: Output<List<KubernetesLabelArgs>>) {
        this.labels = value
    }

    @JvmName("tkcfmoqynniqxiov")
    public suspend fun labels(vararg values: Output<KubernetesLabelArgs>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values The labels applied to the nodes in this agent pool.
     */
    @JvmName("socfvjwpimbpptev")
    public suspend fun labels(values: List<Output<KubernetesLabelArgs>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
     */
    @JvmName("gdpnrbtjwkkkseew")
    public suspend fun mode(`value`: Output<Either<String, AgentPoolMode>>) {
        this.mode = value
    }

    /**
     * @param value The name that will be used for the agent pool resource representing this agent pool.
     */
    @JvmName("wfvigfdvbkromhtc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The taints applied to the nodes in this agent pool.
     */
    @JvmName("lsxhvbnguylhtdjb")
    public suspend fun taints(`value`: Output<List<KubernetesLabelArgs>>) {
        this.taints = value
    }

    @JvmName("kcpwjmkalmacymkt")
    public suspend fun taints(vararg values: Output<KubernetesLabelArgs>) {
        this.taints = Output.all(values.asList())
    }

    /**
     * @param values The taints applied to the nodes in this agent pool.
     */
    @JvmName("qclvgmvxacguuwix")
    public suspend fun taints(values: List<Output<KubernetesLabelArgs>>) {
        this.taints = Output.all(values)
    }

    /**
     * @param value The configuration of the agent pool.
     */
    @JvmName("qdmmksyshqchatmt")
    public suspend fun upgradeSettings(`value`: Output<AgentPoolUpgradeSettingsArgs>) {
        this.upgradeSettings = value
    }

    /**
     * @param value The name of the VM SKU that determines the size of resources allocated for node VMs.
     */
    @JvmName("rafykgxuwuqoegla")
    public suspend fun vmSkuName(`value`: Output<String>) {
        this.vmSkuName = value
    }

    /**
     * @param value The administrator credentials to be used for the nodes in this agent pool.
     */
    @JvmName("eplapefloybukgqp")
    public suspend fun administratorConfiguration(`value`: AdministratorConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorConfiguration = mapped
    }

    /**
     * @param argument The administrator credentials to be used for the nodes in this agent pool.
     */
    @JvmName("dumgnjanedwgmjly")
    public suspend
    fun administratorConfiguration(argument: suspend AdministratorConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AdministratorConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administratorConfiguration = mapped
    }

    /**
     * @param value The configurations that will be applied to each agent in this agent pool.
     */
    @JvmName("qvqclgghakbprewc")
    public suspend fun agentOptions(`value`: AgentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentOptions = mapped
    }

    /**
     * @param argument The configurations that will be applied to each agent in this agent pool.
     */
    @JvmName("sjaumphphwyqfwis")
    public suspend fun agentOptions(argument: suspend AgentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentOptions = mapped
    }

    /**
     * @param value The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
     */
    @JvmName("mqlghyusxsarmhaq")
    public suspend fun attachedNetworkConfiguration(`value`: AttachedNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedNetworkConfiguration = mapped
    }

    /**
     * @param argument The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
     */
    @JvmName("xycpgykysumaqnai")
    public suspend
    fun attachedNetworkConfiguration(argument: suspend AttachedNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AttachedNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attachedNetworkConfiguration = mapped
    }

    /**
     * @param value The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
     */
    @JvmName("hqtkysdcdkykxrgu")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
     */
    @JvmName("nlcxhsggbanqlfdw")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The number of virtual machines that use this configuration.
     */
    @JvmName("iyqqrmvfxpfbxylx")
    public suspend fun count(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The labels applied to the nodes in this agent pool.
     */
    @JvmName("habufteqtpvvysng")
    public suspend fun labels(`value`: List<KubernetesLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param argument The labels applied to the nodes in this agent pool.
     */
    @JvmName("ahgmoybtffdrhxde")
    public suspend fun labels(argument: List<suspend KubernetesLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KubernetesLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument The labels applied to the nodes in this agent pool.
     */
    @JvmName("vgdiltawnxmyydfq")
    public suspend fun labels(vararg argument: suspend KubernetesLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KubernetesLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param argument The labels applied to the nodes in this agent pool.
     */
    @JvmName("koenxjsjxchlwjve")
    public suspend fun labels(argument: suspend KubernetesLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KubernetesLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.labels = mapped
    }

    /**
     * @param values The labels applied to the nodes in this agent pool.
     */
    @JvmName("lbwrnvcxbytcnnwi")
    public suspend fun labels(vararg values: KubernetesLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
     */
    @JvmName("bvhrgmtpmhrkaclw")
    public suspend fun mode(`value`: Either<String, AgentPoolMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
     */
    @JvmName("mrixbcwwwffwytey")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AgentPoolMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
     */
    @JvmName("hjmxqhynwrfkvpyq")
    public fun mode(`value`: AgentPoolMode) {
        val toBeMapped = Either.ofRight<String, AgentPoolMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The name that will be used for the agent pool resource representing this agent pool.
     */
    @JvmName("tolkkusjtasqdxih")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The taints applied to the nodes in this agent pool.
     */
    @JvmName("xcnwpdsdcmosysgj")
    public suspend fun taints(`value`: List<KubernetesLabelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param argument The taints applied to the nodes in this agent pool.
     */
    @JvmName("ucdraerdgefvochn")
    public suspend fun taints(argument: List<suspend KubernetesLabelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KubernetesLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument The taints applied to the nodes in this agent pool.
     */
    @JvmName("suercrmiclmkvosf")
    public suspend fun taints(vararg argument: suspend KubernetesLabelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KubernetesLabelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument The taints applied to the nodes in this agent pool.
     */
    @JvmName("tojymefnfjerrpbt")
    public suspend fun taints(argument: suspend KubernetesLabelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KubernetesLabelArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param values The taints applied to the nodes in this agent pool.
     */
    @JvmName("nhmuwuhqavswskjx")
    public suspend fun taints(vararg values: KubernetesLabelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param value The configuration of the agent pool.
     */
    @JvmName("udffogvvvxuermnf")
    public suspend fun upgradeSettings(`value`: AgentPoolUpgradeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeSettings = mapped
    }

    /**
     * @param argument The configuration of the agent pool.
     */
    @JvmName("qajfxstrarexsowf")
    public suspend
    fun upgradeSettings(argument: suspend AgentPoolUpgradeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPoolUpgradeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upgradeSettings = mapped
    }

    /**
     * @param value The name of the VM SKU that determines the size of resources allocated for node VMs.
     */
    @JvmName("mcveviybjebromrb")
    public suspend fun vmSkuName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSkuName = mapped
    }

    internal fun build(): InitialAgentPoolConfigurationArgs = InitialAgentPoolConfigurationArgs(
        administratorConfiguration = administratorConfiguration,
        agentOptions = agentOptions,
        attachedNetworkConfiguration = attachedNetworkConfiguration,
        availabilityZones = availabilityZones,
        count = count ?: throw PulumiNullFieldException("count"),
        labels = labels,
        mode = mode ?: throw PulumiNullFieldException("mode"),
        name = name ?: throw PulumiNullFieldException("name"),
        taints = taints,
        upgradeSettings = upgradeSettings,
        vmSkuName = vmSkuName ?: throw PulumiNullFieldException("vmSkuName"),
    )
}
