@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.ServiceLoadBalancerBgpPeerArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.BfdEnabled
import com.pulumi.azurenative.networkcloud.kotlin.enums.BgpMultiHop
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bfdEnabled The indicator of BFD enablement for this BgpPeer.
 * @property bgpMultiHop The indicator to enable multi-hop peering support.
 * @property holdTime The requested BGP hold time value. This field uses ISO 8601 duration format, for example P1H.
 * @property keepAliveTime The requested BGP keepalive time value. This field uses ISO 8601 duration format, for example P1H.
 * @property myAsn The autonomous system number used for the local end of the BGP session.
 * @property name The name used to identify this BGP peer for association with a BGP advertisement.
 * @property password The authentication password for routers enforcing TCP MD5 authenticated sessions.
 * @property peerAddress The IPv4 or IPv6 address used to connect this BGP session.
 * @property peerAsn The autonomous system number expected from the remote end of the BGP session.
 * @property peerPort The port used to connect this BGP session.
 */
public data class ServiceLoadBalancerBgpPeerArgs(
    public val bfdEnabled: Output<Either<String, BfdEnabled>>? = null,
    public val bgpMultiHop: Output<Either<String, BgpMultiHop>>? = null,
    public val holdTime: Output<String>? = null,
    public val keepAliveTime: Output<String>? = null,
    public val myAsn: Output<Double>? = null,
    public val name: Output<String>,
    public val password: Output<String>? = null,
    public val peerAddress: Output<String>,
    public val peerAsn: Output<Double>,
    public val peerPort: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.ServiceLoadBalancerBgpPeerArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.ServiceLoadBalancerBgpPeerArgs =
        com.pulumi.azurenative.networkcloud.inputs.ServiceLoadBalancerBgpPeerArgs.builder()
            .bfdEnabled(
                bfdEnabled?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .bgpMultiHop(
                bgpMultiHop?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .holdTime(holdTime?.applyValue({ args0 -> args0 }))
            .keepAliveTime(keepAliveTime?.applyValue({ args0 -> args0 }))
            .myAsn(myAsn?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .peerAddress(peerAddress.applyValue({ args0 -> args0 }))
            .peerAsn(peerAsn.applyValue({ args0 -> args0 }))
            .peerPort(peerPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceLoadBalancerBgpPeerArgs].
 */
@PulumiTagMarker
public class ServiceLoadBalancerBgpPeerArgsBuilder internal constructor() {
    private var bfdEnabled: Output<Either<String, BfdEnabled>>? = null

    private var bgpMultiHop: Output<Either<String, BgpMultiHop>>? = null

    private var holdTime: Output<String>? = null

    private var keepAliveTime: Output<String>? = null

    private var myAsn: Output<Double>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var peerAddress: Output<String>? = null

    private var peerAsn: Output<Double>? = null

    private var peerPort: Output<Double>? = null

    /**
     * @param value The indicator of BFD enablement for this BgpPeer.
     */
    @JvmName("myniixqvdocgsuty")
    public suspend fun bfdEnabled(`value`: Output<Either<String, BfdEnabled>>) {
        this.bfdEnabled = value
    }

    /**
     * @param value The indicator to enable multi-hop peering support.
     */
    @JvmName("ilpchxofdaaoieka")
    public suspend fun bgpMultiHop(`value`: Output<Either<String, BgpMultiHop>>) {
        this.bgpMultiHop = value
    }

    /**
     * @param value The requested BGP hold time value. This field uses ISO 8601 duration format, for example P1H.
     */
    @JvmName("fifxkkxvommrodgp")
    public suspend fun holdTime(`value`: Output<String>) {
        this.holdTime = value
    }

    /**
     * @param value The requested BGP keepalive time value. This field uses ISO 8601 duration format, for example P1H.
     */
    @JvmName("xxovyrhievvvacxt")
    public suspend fun keepAliveTime(`value`: Output<String>) {
        this.keepAliveTime = value
    }

    /**
     * @param value The autonomous system number used for the local end of the BGP session.
     */
    @JvmName("koqjwgfjkruosoxy")
    public suspend fun myAsn(`value`: Output<Double>) {
        this.myAsn = value
    }

    /**
     * @param value The name used to identify this BGP peer for association with a BGP advertisement.
     */
    @JvmName("gafuwgmrevqhgqid")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The authentication password for routers enforcing TCP MD5 authenticated sessions.
     */
    @JvmName("eimhqnfptwoqoafs")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The IPv4 or IPv6 address used to connect this BGP session.
     */
    @JvmName("sdvrrckloejudfal")
    public suspend fun peerAddress(`value`: Output<String>) {
        this.peerAddress = value
    }

    /**
     * @param value The autonomous system number expected from the remote end of the BGP session.
     */
    @JvmName("tiycwgoevthlhkqb")
    public suspend fun peerAsn(`value`: Output<Double>) {
        this.peerAsn = value
    }

    /**
     * @param value The port used to connect this BGP session.
     */
    @JvmName("ybceqbtnmcmhdldk")
    public suspend fun peerPort(`value`: Output<Double>) {
        this.peerPort = value
    }

    /**
     * @param value The indicator of BFD enablement for this BgpPeer.
     */
    @JvmName("ypiqiikysvnxfjac")
    public suspend fun bfdEnabled(`value`: Either<String, BfdEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bfdEnabled = mapped
    }

    /**
     * @param value The indicator of BFD enablement for this BgpPeer.
     */
    @JvmName("hwiqxumcqiupakmw")
    public fun bfdEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BfdEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bfdEnabled = mapped
    }

    /**
     * @param value The indicator of BFD enablement for this BgpPeer.
     */
    @JvmName("bdnksltklambefst")
    public fun bfdEnabled(`value`: BfdEnabled) {
        val toBeMapped = Either.ofRight<String, BfdEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bfdEnabled = mapped
    }

    /**
     * @param value The indicator to enable multi-hop peering support.
     */
    @JvmName("sfhgoyvxjauiknfp")
    public suspend fun bgpMultiHop(`value`: Either<String, BgpMultiHop>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpMultiHop = mapped
    }

    /**
     * @param value The indicator to enable multi-hop peering support.
     */
    @JvmName("oabuiwckvjnnnuny")
    public fun bgpMultiHop(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BgpMultiHop>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bgpMultiHop = mapped
    }

    /**
     * @param value The indicator to enable multi-hop peering support.
     */
    @JvmName("frirwktnwyepvxbw")
    public fun bgpMultiHop(`value`: BgpMultiHop) {
        val toBeMapped = Either.ofRight<String, BgpMultiHop>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bgpMultiHop = mapped
    }

    /**
     * @param value The requested BGP hold time value. This field uses ISO 8601 duration format, for example P1H.
     */
    @JvmName("pvgewkilcphcxmdb")
    public suspend fun holdTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.holdTime = mapped
    }

    /**
     * @param value The requested BGP keepalive time value. This field uses ISO 8601 duration format, for example P1H.
     */
    @JvmName("ehmsroqyyvhgihac")
    public suspend fun keepAliveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepAliveTime = mapped
    }

    /**
     * @param value The autonomous system number used for the local end of the BGP session.
     */
    @JvmName("jtjqtcxffxdxwsuk")
    public suspend fun myAsn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.myAsn = mapped
    }

    /**
     * @param value The name used to identify this BGP peer for association with a BGP advertisement.
     */
    @JvmName("rjqubsckvbfwwiok")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The authentication password for routers enforcing TCP MD5 authenticated sessions.
     */
    @JvmName("wxovugvthyrgpugn")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The IPv4 or IPv6 address used to connect this BGP session.
     */
    @JvmName("ftjsgpxwipvolesh")
    public suspend fun peerAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerAddress = mapped
    }

    /**
     * @param value The autonomous system number expected from the remote end of the BGP session.
     */
    @JvmName("keurpywqorbcvevy")
    public suspend fun peerAsn(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    /**
     * @param value The port used to connect this BGP session.
     */
    @JvmName("rmemxgvqhqubwovt")
    public suspend fun peerPort(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerPort = mapped
    }

    internal fun build(): ServiceLoadBalancerBgpPeerArgs = ServiceLoadBalancerBgpPeerArgs(
        bfdEnabled = bfdEnabled,
        bgpMultiHop = bgpMultiHop,
        holdTime = holdTime,
        keepAliveTime = keepAliveTime,
        myAsn = myAsn,
        name = name ?: throw PulumiNullFieldException("name"),
        password = password,
        peerAddress = peerAddress ?: throw PulumiNullFieldException("peerAddress"),
        peerAsn = peerAsn ?: throw PulumiNullFieldException("peerAsn"),
        peerPort = peerPort,
    )
}
