@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.TrunkedNetworkAttachmentConfigurationArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.KubernetesPluginType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkId The resource ID of the network that is being configured for attachment.
 * @property pluginType The indicator of how this network will be utilized by the Kubernetes cluster.
 */
public data class TrunkedNetworkAttachmentConfigurationArgs(
    public val networkId: Output<String>,
    public val pluginType: Output<Either<String, KubernetesPluginType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.TrunkedNetworkAttachmentConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkcloud.inputs.TrunkedNetworkAttachmentConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.TrunkedNetworkAttachmentConfigurationArgs.builder()
            .networkId(networkId.applyValue({ args0 -> args0 }))
            .pluginType(
                pluginType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [TrunkedNetworkAttachmentConfigurationArgs].
 */
@PulumiTagMarker
public class TrunkedNetworkAttachmentConfigurationArgsBuilder internal constructor() {
    private var networkId: Output<String>? = null

    private var pluginType: Output<Either<String, KubernetesPluginType>>? = null

    /**
     * @param value The resource ID of the network that is being configured for attachment.
     */
    @JvmName("kdhqbponvaphmkqw")
    public suspend fun networkId(`value`: Output<String>) {
        this.networkId = value
    }

    /**
     * @param value The indicator of how this network will be utilized by the Kubernetes cluster.
     */
    @JvmName("apurbrrjypbegwsg")
    public suspend fun pluginType(`value`: Output<Either<String, KubernetesPluginType>>) {
        this.pluginType = value
    }

    /**
     * @param value The resource ID of the network that is being configured for attachment.
     */
    @JvmName("wmujxhqsamikguud")
    public suspend fun networkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkId = mapped
    }

    /**
     * @param value The indicator of how this network will be utilized by the Kubernetes cluster.
     */
    @JvmName("cbuqddjxanmuinrq")
    public suspend fun pluginType(`value`: Either<String, KubernetesPluginType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pluginType = mapped
    }

    /**
     * @param value The indicator of how this network will be utilized by the Kubernetes cluster.
     */
    @JvmName("gknoregpvqhfeesy")
    public fun pluginType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KubernetesPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pluginType = mapped
    }

    /**
     * @param value The indicator of how this network will be utilized by the Kubernetes cluster.
     */
    @JvmName("vhinutedofrqaric")
    public fun pluginType(`value`: KubernetesPluginType) {
        val toBeMapped = Either.ofRight<String, KubernetesPluginType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pluginType = mapped
    }

    internal fun build(): TrunkedNetworkAttachmentConfigurationArgs =
        TrunkedNetworkAttachmentConfigurationArgs(
            networkId = networkId ?: throw PulumiNullFieldException("networkId"),
            pluginType = pluginType,
        )
}
