@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property l2Networks The list of Layer 2 Networks and related configuration for attachment.
 * @property l3Networks The list of Layer 3 Networks and related configuration for attachment.
 * @property trunkedNetworks The list of Trunked Networks and related configuration for attachment.
 */
public data class AttachedNetworkConfigurationResponse(
    public val l2Networks: List<L2NetworkAttachmentConfigurationResponse>? = null,
    public val l3Networks: List<L3NetworkAttachmentConfigurationResponse>? = null,
    public val trunkedNetworks: List<TrunkedNetworkAttachmentConfigurationResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.AttachedNetworkConfigurationResponse):
            AttachedNetworkConfigurationResponse = AttachedNetworkConfigurationResponse(
            l2Networks = javaType.l2Networks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.L2NetworkAttachmentConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            l3Networks = javaType.l3Networks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.L3NetworkAttachmentConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            trunkedNetworks = javaType.trunkedNetworks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.TrunkedNetworkAttachmentConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
