@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property controlImpact The indicator of whether the control plane will be impacted during the upgrade.
 * @property expectedDuration The expected duration needed for this upgrade.
 * @property impactDescription The impact description including the specific details and release notes.
 * @property supportExpiryDate The last date the version of the platform is supported.
 * @property targetClusterVersion The target version this cluster will be upgraded to.
 * @property workloadImpact The indicator of whether the workload will be impacted during the upgrade.
 */
public data class ClusterAvailableUpgradeVersionResponse(
    public val controlImpact: String,
    public val expectedDuration: String,
    public val impactDescription: String,
    public val supportExpiryDate: String,
    public val targetClusterVersion: String,
    public val workloadImpact: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ClusterAvailableUpgradeVersionResponse):
            ClusterAvailableUpgradeVersionResponse = ClusterAvailableUpgradeVersionResponse(
            controlImpact = javaType.controlImpact(),
            expectedDuration = javaType.expectedDuration(),
            impactDescription = javaType.impactDescription(),
            supportExpiryDate = javaType.supportExpiryDate(),
            targetClusterVersion = javaType.targetClusterVersion(),
            workloadImpact = javaType.workloadImpact(),
        )
    }
}
