@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property associatedResourceIds The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
 * @property clusterId The resource ID of the Network Cloud cluster this trunked network is associated with.
 * @property detailedStatus The more detailed status of the trunked network.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property hybridAksClustersAssociatedIds Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource IDs that are associated with this trunked network.
 * @property hybridAksPluginType Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property interfaceName The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
 * @property isolationDomainIds The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the trunked network.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualMachinesAssociatedIds Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are currently using this trunked network.
 * @property vlans The list of vlans that are selected from the isolation domains for trunking.
 */
public data class GetTrunkedNetworkResult(
    public val associatedResourceIds: List<String>,
    public val clusterId: String,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val hybridAksClustersAssociatedIds: List<String>,
    public val hybridAksPluginType: String? = null,
    public val id: String,
    public val interfaceName: String? = null,
    public val isolationDomainIds: List<String>,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualMachinesAssociatedIds: List<String>,
    public val vlans: List<Double>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetTrunkedNetworkResult):
            GetTrunkedNetworkResult = GetTrunkedNetworkResult(
            associatedResourceIds = javaType.associatedResourceIds().map({ args0 -> args0 }),
            clusterId = javaType.clusterId(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            hybridAksClustersAssociatedIds = javaType.hybridAksClustersAssociatedIds().map({ args0 -> args0 }),
            hybridAksPluginType = javaType.hybridAksPluginType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            interfaceName = javaType.interfaceName().map({ args0 -> args0 }).orElse(null),
            isolationDomainIds = javaType.isolationDomainIds().map({ args0 -> args0 }),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualMachinesAssociatedIds = javaType.virtualMachinesAssociatedIds().map({ args0 -> args0 }),
            vlans = javaType.vlans().map({ args0 -> args0 }),
        )
    }
}
