@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property linkStatus The current status of the link.
 * @property macAddress The MAC address associated with this interface.
 * @property name The name of the interface.
 * @property networkInterfaceId The resource ID of the network interface for the port on the switch that this machine's interface is connected to.
 */
public data class HardwareInventoryNetworkInterfaceResponse(
    public val linkStatus: String,
    public val macAddress: String,
    public val name: String,
    public val networkInterfaceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.HardwareInventoryNetworkInterfaceResponse):
            HardwareInventoryNetworkInterfaceResponse = HardwareInventoryNetworkInterfaceResponse(
            linkStatus = javaType.linkStatus(),
            macAddress = javaType.macAddress(),
            name = javaType.name(),
            networkInterfaceId = javaType.networkInterfaceId(),
        )
    }
}
