@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property lastValidationTime The timestamp of the hardware validation execution.
 * @property result The outcome of the hardware validation.
 */
public data class HardwareValidationStatusResponse(
    public val lastValidationTime: String,
    public val result: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.HardwareValidationStatusResponse):
            HardwareValidationStatusResponse = HardwareValidationStatusResponse(
            lastValidationTime = javaType.lastValidationTime(),
            result = javaType.result(),
        )
    }
}
