@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property networkId The resource ID of the network that is being configured for attachment.
 * @property pluginType The indicator of how this network will be utilized by the Kubernetes cluster.
 */
public data class L2NetworkAttachmentConfigurationResponse(
    public val networkId: String,
    public val pluginType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.L2NetworkAttachmentConfigurationResponse):
            L2NetworkAttachmentConfigurationResponse = L2NetworkAttachmentConfigurationResponse(
            networkId = javaType.networkId(),
            pluginType = javaType.pluginType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
