@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property lldpNeighbor The information about the device connected to this NIC.
 * @property macAddress The MAC address associated with this NIC.
 * @property name The name of the NIC/interface.
 */
public data class NicResponse(
    public val lldpNeighbor: LldpNeighborResponse,
    public val macAddress: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.NicResponse):
            NicResponse = NicResponse(
            lldpNeighbor = javaType.lldpNeighbor().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.LldpNeighborResponse.Companion.toKotlin(args0)
            }),
            macAddress = javaType.macAddress(),
            name = javaType.name(),
        )
    }
}
