@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property adminCredentials The credentials of the administrative interface on this storage appliance.
 * @property rackSlot The slot that storage appliance is in the rack based on the BOM configuration.
 * @property serialNumber The serial number of the appliance.
 * @property storageApplianceName The user-provided name for the storage appliance that will be created from this specification.
 */
public data class StorageApplianceConfigurationDataResponse(
    public val adminCredentials: AdministrativeCredentialsResponse,
    public val rackSlot: Double,
    public val serialNumber: String,
    public val storageApplianceName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.StorageApplianceConfigurationDataResponse):
            StorageApplianceConfigurationDataResponse = StorageApplianceConfigurationDataResponse(
            adminCredentials = javaType.adminCredentials().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministrativeCredentialsResponse.Companion.toKotlin(args0)
            }),
            rackSlot = javaType.rackSlot(),
            serialNumber = javaType.serialNumber(),
            storageApplianceName = javaType.storageApplianceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
