@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin

import com.pulumi.azurenative.networkfunction.CollectorPolicyArgs.builder
import com.pulumi.azurenative.networkfunction.kotlin.inputs.EmissionPoliciesPropertiesFormatArgs
import com.pulumi.azurenative.networkfunction.kotlin.inputs.EmissionPoliciesPropertiesFormatArgsBuilder
import com.pulumi.azurenative.networkfunction.kotlin.inputs.IngestionPolicyPropertiesFormatArgs
import com.pulumi.azurenative.networkfunction.kotlin.inputs.IngestionPolicyPropertiesFormatArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Collector policy resource.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2022-05-01.
 * Other available API versions: 2022-05-01.
 * ## Example Usage
 * ### Create a collection policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var collectorPolicy = new AzureNative.NetworkFunction.CollectorPolicy("collectorPolicy", new()
 *     {
 *         AzureTrafficCollectorName = "atc",
 *         CollectorPolicyName = "cp1",
 *         EmissionPolicies = new[]
 *         {
 *             new AzureNative.NetworkFunction.Inputs.EmissionPoliciesPropertiesFormatArgs
 *             {
 *                 EmissionDestinations = new[]
 *                 {
 *                     new AzureNative.NetworkFunction.Inputs.EmissionPolicyDestinationArgs
 *                     {
 *                         DestinationType = AzureNative.NetworkFunction.DestinationType.AzureMonitor,
 *                     },
 *                 },
 *                 EmissionType = AzureNative.NetworkFunction.EmissionType.IPFIX,
 *             },
 *         },
 *         IngestionPolicy = new AzureNative.NetworkFunction.Inputs.IngestionPolicyPropertiesFormatArgs
 *         {
 *             IngestionSources = new[]
 *             {
 *                 new AzureNative.NetworkFunction.Inputs.IngestionSourcesPropertiesFormatArgs
 *                 {
 *                     ResourceId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName",
 *                     SourceType = AzureNative.NetworkFunction.SourceType.Resource,
 *                 },
 *             },
 *             IngestionType = AzureNative.NetworkFunction.IngestionType.IPFIX,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkfunction/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfunction.NewCollectorPolicy(ctx, "collectorPolicy", &networkfunction.CollectorPolicyArgs{
 * 			AzureTrafficCollectorName: pulumi.String("atc"),
 * 			CollectorPolicyName:       pulumi.String("cp1"),
 * 			EmissionPolicies: networkfunction.EmissionPoliciesPropertiesFormatArray{
 * 				&networkfunction.EmissionPoliciesPropertiesFormatArgs{
 * 					EmissionDestinations: networkfunction.EmissionPolicyDestinationArray{
 * 						&networkfunction.EmissionPolicyDestinationArgs{
 * 							DestinationType: pulumi.String(networkfunction.DestinationTypeAzureMonitor),
 * 						},
 * 					},
 * 					EmissionType: pulumi.String(networkfunction.EmissionTypeIPFIX),
 * 				},
 * 			},
 * 			IngestionPolicy: &networkfunction.IngestionPolicyPropertiesFormatArgs{
 * 				IngestionSources: networkfunction.IngestionSourcesPropertiesFormatArray{
 * 					&networkfunction.IngestionSourcesPropertiesFormatArgs{
 * 						ResourceId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName"),
 * 						SourceType: pulumi.String(networkfunction.SourceTypeResource),
 * 					},
 * 				},
 * 				IngestionType: pulumi.String(networkfunction.IngestionTypeIPFIX),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkfunction.CollectorPolicy;
 * import com.pulumi.azurenative.networkfunction.CollectorPolicyArgs;
 * import com.pulumi.azurenative.networkfunction.inputs.EmissionPoliciesPropertiesFormatArgs;
 * import com.pulumi.azurenative.networkfunction.inputs.IngestionPolicyPropertiesFormatArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var collectorPolicy = new CollectorPolicy("collectorPolicy", CollectorPolicyArgs.builder()
 *             .azureTrafficCollectorName("atc")
 *             .collectorPolicyName("cp1")
 *             .emissionPolicies(EmissionPoliciesPropertiesFormatArgs.builder()
 *                 .emissionDestinations(EmissionPolicyDestinationArgs.builder()
 *                     .destinationType("AzureMonitor")
 *                     .build())
 *                 .emissionType("IPFIX")
 *                 .build())
 *             .ingestionPolicy(IngestionPolicyPropertiesFormatArgs.builder()
 *                 .ingestionSources(IngestionSourcesPropertiesFormatArgs.builder()
 *                     .resourceId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteCircuits/circuitName")
 *                     .sourceType("Resource")
 *                     .build())
 *                 .ingestionType("IPFIX")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkfunction:CollectorPolicy cp1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}/collectorPolicies/{collectorPolicyName}
 * ```
 * @property azureTrafficCollectorName Azure Traffic Collector name
 * @property collectorPolicyName Collector Policy Name
 * @property emissionPolicies Emission policies.
 * @property ingestionPolicy Ingestion policies.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class CollectorPolicyArgs(
    public val azureTrafficCollectorName: Output<String>? = null,
    public val collectorPolicyName: Output<String>? = null,
    public val emissionPolicies: Output<List<EmissionPoliciesPropertiesFormatArgs>>? = null,
    public val ingestionPolicy: Output<IngestionPolicyPropertiesFormatArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkfunction.CollectorPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.networkfunction.CollectorPolicyArgs =
        com.pulumi.azurenative.networkfunction.CollectorPolicyArgs.builder()
            .azureTrafficCollectorName(azureTrafficCollectorName?.applyValue({ args0 -> args0 }))
            .collectorPolicyName(collectorPolicyName?.applyValue({ args0 -> args0 }))
            .emissionPolicies(
                emissionPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ingestionPolicy(ingestionPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CollectorPolicyArgs].
 */
@PulumiTagMarker
public class CollectorPolicyArgsBuilder internal constructor() {
    private var azureTrafficCollectorName: Output<String>? = null

    private var collectorPolicyName: Output<String>? = null

    private var emissionPolicies: Output<List<EmissionPoliciesPropertiesFormatArgs>>? = null

    private var ingestionPolicy: Output<IngestionPolicyPropertiesFormatArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Azure Traffic Collector name
     */
    @JvmName("qatfqlquxmkomhcl")
    public suspend fun azureTrafficCollectorName(`value`: Output<String>) {
        this.azureTrafficCollectorName = value
    }

    /**
     * @param value Collector Policy Name
     */
    @JvmName("hfmlcvetjblfbnlr")
    public suspend fun collectorPolicyName(`value`: Output<String>) {
        this.collectorPolicyName = value
    }

    /**
     * @param value Emission policies.
     */
    @JvmName("vemesxtwcvihxkar")
    public suspend fun emissionPolicies(`value`: Output<List<EmissionPoliciesPropertiesFormatArgs>>) {
        this.emissionPolicies = value
    }

    @JvmName("ftvxuwaxerxdcqen")
    public suspend fun emissionPolicies(vararg values: Output<EmissionPoliciesPropertiesFormatArgs>) {
        this.emissionPolicies = Output.all(values.asList())
    }

    /**
     * @param values Emission policies.
     */
    @JvmName("lvdbhfhkkxchpikk")
    public suspend fun emissionPolicies(values: List<Output<EmissionPoliciesPropertiesFormatArgs>>) {
        this.emissionPolicies = Output.all(values)
    }

    /**
     * @param value Ingestion policies.
     */
    @JvmName("tdnciyfitipdsbfi")
    public suspend fun ingestionPolicy(`value`: Output<IngestionPolicyPropertiesFormatArgs>) {
        this.ingestionPolicy = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("dodvthkxgyapvekd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qwsrbfxawdylovdy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jsbpfsldxufgwigo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Azure Traffic Collector name
     */
    @JvmName("vhwyowqwiiirptxc")
    public suspend fun azureTrafficCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureTrafficCollectorName = mapped
    }

    /**
     * @param value Collector Policy Name
     */
    @JvmName("crprhvknucrvhgfs")
    public suspend fun collectorPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectorPolicyName = mapped
    }

    /**
     * @param value Emission policies.
     */
    @JvmName("tvgifievyicwbaem")
    public suspend fun emissionPolicies(`value`: List<EmissionPoliciesPropertiesFormatArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emissionPolicies = mapped
    }

    /**
     * @param argument Emission policies.
     */
    @JvmName("sxohwwnucwsdouer")
    public suspend
    fun emissionPolicies(argument: List<suspend EmissionPoliciesPropertiesFormatArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EmissionPoliciesPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emissionPolicies = mapped
    }

    /**
     * @param argument Emission policies.
     */
    @JvmName("rtnaqbregqsxrnsn")
    public suspend fun emissionPolicies(
        vararg
        argument: suspend EmissionPoliciesPropertiesFormatArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EmissionPoliciesPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.emissionPolicies = mapped
    }

    /**
     * @param argument Emission policies.
     */
    @JvmName("jolvwcirlifknegy")
    public suspend
    fun emissionPolicies(argument: suspend EmissionPoliciesPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EmissionPoliciesPropertiesFormatArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.emissionPolicies = mapped
    }

    /**
     * @param values Emission policies.
     */
    @JvmName("fftpvqttvlhhaqhk")
    public suspend fun emissionPolicies(vararg values: EmissionPoliciesPropertiesFormatArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emissionPolicies = mapped
    }

    /**
     * @param value Ingestion policies.
     */
    @JvmName("xiewdmeitxdaccsb")
    public suspend fun ingestionPolicy(`value`: IngestionPolicyPropertiesFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionPolicy = mapped
    }

    /**
     * @param argument Ingestion policies.
     */
    @JvmName("koefhyswugbqjtbg")
    public suspend
    fun ingestionPolicy(argument: suspend IngestionPolicyPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = IngestionPolicyPropertiesFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ingestionPolicy = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("uuwyhigsjjaqcdsj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qrptvkimiadsngxa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oxernobnghnnilav")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rvjlokqvcyhvwewj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CollectorPolicyArgs = CollectorPolicyArgs(
        azureTrafficCollectorName = azureTrafficCollectorName,
        collectorPolicyName = collectorPolicyName,
        emissionPolicies = emissionPolicies,
        ingestionPolicy = ingestionPolicy,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
