@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin

import com.pulumi.azurenative.networkfunction.NetworkfunctionFunctions.getAzureTrafficCollectorPlain
import com.pulumi.azurenative.networkfunction.NetworkfunctionFunctions.getCollectorPolicyPlain
import com.pulumi.azurenative.networkfunction.kotlin.inputs.GetAzureTrafficCollectorPlainArgs
import com.pulumi.azurenative.networkfunction.kotlin.inputs.GetAzureTrafficCollectorPlainArgsBuilder
import com.pulumi.azurenative.networkfunction.kotlin.inputs.GetCollectorPolicyPlainArgs
import com.pulumi.azurenative.networkfunction.kotlin.inputs.GetCollectorPolicyPlainArgsBuilder
import com.pulumi.azurenative.networkfunction.kotlin.outputs.GetAzureTrafficCollectorResult
import com.pulumi.azurenative.networkfunction.kotlin.outputs.GetCollectorPolicyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.networkfunction.kotlin.outputs.GetAzureTrafficCollectorResult.Companion.toKotlin as getAzureTrafficCollectorResultToKotlin
import com.pulumi.azurenative.networkfunction.kotlin.outputs.GetCollectorPolicyResult.Companion.toKotlin as getCollectorPolicyResultToKotlin

public object NetworkfunctionFunctions {
    /**
     * Gets the specified Azure Traffic Collector in a specified resource group
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-08-01.
     * @param argument null
     * @return Azure Traffic Collector resource.
     */
    public suspend fun getAzureTrafficCollector(argument: GetAzureTrafficCollectorPlainArgs):
        GetAzureTrafficCollectorResult =
        getAzureTrafficCollectorResultToKotlin(getAzureTrafficCollectorPlain(argument.toJava()).await())

    /**
     * @see [getAzureTrafficCollector].
     * @param azureTrafficCollectorName Azure Traffic Collector name
     * @param resourceGroupName The name of the resource group.
     * @return Azure Traffic Collector resource.
     */
    public suspend fun getAzureTrafficCollector(
        azureTrafficCollectorName: String,
        resourceGroupName: String,
    ): GetAzureTrafficCollectorResult {
        val argument = GetAzureTrafficCollectorPlainArgs(
            azureTrafficCollectorName = azureTrafficCollectorName,
            resourceGroupName = resourceGroupName,
        )
        return getAzureTrafficCollectorResultToKotlin(getAzureTrafficCollectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAzureTrafficCollector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkfunction&#46;kotlin&#46;inputs&#46;GetAzureTrafficCollectorPlainArgs].
     * @return Azure Traffic Collector resource.
     */
    public suspend
    fun getAzureTrafficCollector(argument: suspend GetAzureTrafficCollectorPlainArgsBuilder.() -> Unit):
        GetAzureTrafficCollectorResult {
        val builder = GetAzureTrafficCollectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAzureTrafficCollectorResultToKotlin(getAzureTrafficCollectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the collector policy in a specified Traffic Collector
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-05-01.
     * @param argument null
     * @return Collector policy resource.
     */
    public suspend fun getCollectorPolicy(argument: GetCollectorPolicyPlainArgs):
        GetCollectorPolicyResult =
        getCollectorPolicyResultToKotlin(getCollectorPolicyPlain(argument.toJava()).await())

    /**
     * @see [getCollectorPolicy].
     * @param azureTrafficCollectorName Azure Traffic Collector name
     * @param collectorPolicyName Collector Policy Name
     * @param resourceGroupName The name of the resource group.
     * @return Collector policy resource.
     */
    public suspend fun getCollectorPolicy(
        azureTrafficCollectorName: String,
        collectorPolicyName: String,
        resourceGroupName: String,
    ): GetCollectorPolicyResult {
        val argument = GetCollectorPolicyPlainArgs(
            azureTrafficCollectorName = azureTrafficCollectorName,
            collectorPolicyName = collectorPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getCollectorPolicyResultToKotlin(getCollectorPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getCollectorPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkfunction&#46;kotlin&#46;inputs&#46;GetCollectorPolicyPlainArgs].
     * @return Collector policy resource.
     */
    public suspend
    fun getCollectorPolicy(argument: suspend GetCollectorPolicyPlainArgsBuilder.() -> Unit):
        GetCollectorPolicyResult {
        val builder = GetCollectorPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCollectorPolicyResultToKotlin(getCollectorPolicyPlain(builtArgument.toJava()).await())
    }
}
