@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.inputs

import com.pulumi.azurenative.networkfunction.inputs.IngestionSourcesPropertiesFormatArgs.builder
import com.pulumi.azurenative.networkfunction.kotlin.enums.SourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Ingestion policy properties.
 * @property resourceId Resource ID.
 * @property sourceType Ingestion source type.
 */
public data class IngestionSourcesPropertiesFormatArgs(
    public val resourceId: Output<String>? = null,
    public val sourceType: Output<Either<String, SourceType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkfunction.inputs.IngestionSourcesPropertiesFormatArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkfunction.inputs.IngestionSourcesPropertiesFormatArgs =
        com.pulumi.azurenative.networkfunction.inputs.IngestionSourcesPropertiesFormatArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .sourceType(
                sourceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [IngestionSourcesPropertiesFormatArgs].
 */
@PulumiTagMarker
public class IngestionSourcesPropertiesFormatArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var sourceType: Output<Either<String, SourceType>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("mpmjuclaybsohrxl")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Ingestion source type.
     */
    @JvmName("hawvrfddwvlicepp")
    public suspend fun sourceType(`value`: Output<Either<String, SourceType>>) {
        this.sourceType = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qvaorgkirxucvuei")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Ingestion source type.
     */
    @JvmName("xlyuprisowlouthh")
    public suspend fun sourceType(`value`: Either<String, SourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Ingestion source type.
     */
    @JvmName("ftulevlxdpahlxjv")
    public fun sourceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Ingestion source type.
     */
    @JvmName("xlmydyfrlkngoqys")
    public fun sourceType(`value`: SourceType) {
        val toBeMapped = Either.ofRight<String, SourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    internal fun build(): IngestionSourcesPropertiesFormatArgs = IngestionSourcesPropertiesFormatArgs(
        resourceId = resourceId,
        sourceType = sourceType,
    )
}
