@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin

import com.pulumi.azurenative.notificationhubs.NamespaceArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.NamespacePropertiesArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.NamespacePropertiesArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Notification Hubs Namespace Resource.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2014-09-01, 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Namespaces_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @namespace = new AzureNative.NotificationHubs.Namespace("namespace", new()
 *     {
 *         Location = "South Central US",
 *         NamespaceName = "nh-sdk-ns",
 *         Properties = new AzureNative.NotificationHubs.Inputs.NamespacePropertiesArgs
 *         {
 *             NetworkAcls = new AzureNative.NotificationHubs.Inputs.NetworkAclsArgs
 *             {
 *                 IpRules = new[]
 *                 {
 *                     new AzureNative.NotificationHubs.Inputs.IpRuleArgs
 *                     {
 *                         IpMask = "185.48.100.00/24",
 *                         Rights = new[]
 *                         {
 *                             AzureNative.NotificationHubs.AccessRights.Manage,
 *                             AzureNative.NotificationHubs.AccessRights.Send,
 *                             AzureNative.NotificationHubs.AccessRights.Listen,
 *                         },
 *                     },
 *                 },
 *                 PublicNetworkRule = new AzureNative.NotificationHubs.Inputs.PublicInternetAuthorizationRuleArgs
 *                 {
 *                     Rights = new[]
 *                     {
 *                         AzureNative.NotificationHubs.AccessRights.Listen,
 *                     },
 *                 },
 *             },
 *             ZoneRedundancy = AzureNative.NotificationHubs.ZoneRedundancyPreference.Enabled,
 *         },
 *         ResourceGroupName = "5ktrial",
 *         Sku = new AzureNative.NotificationHubs.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.NotificationHubs.SkuName.Standard,
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/notificationhubs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := notificationhubs.NewNamespace(ctx, "namespace", &notificationhubs.NamespaceArgs{
 * 			Location:      pulumi.String("South Central US"),
 * 			NamespaceName: pulumi.String("nh-sdk-ns"),
 * 			Properties: &notificationhubs.NamespacePropertiesArgs{
 * 				NetworkAcls: &notificationhubs.NetworkAclsArgs{
 * 					IpRules: notificationhubs.IpRuleArray{
 * 						&notificationhubs.IpRuleArgs{
 * 							IpMask: pulumi.String("185.48.100.00/24"),
 * 							Rights: pulumi.StringArray{
 * 								pulumi.String(notificationhubs.AccessRightsManage),
 * 								pulumi.String(notificationhubs.AccessRightsSend),
 * 								pulumi.String(notificationhubs.AccessRightsListen),
 * 							},
 * 						},
 * 					},
 * 					PublicNetworkRule: &notificationhubs.PublicInternetAuthorizationRuleArgs{
 * 						Rights: pulumi.StringArray{
 * 							pulumi.String(notificationhubs.AccessRightsListen),
 * 						},
 * 					},
 * 				},
 * 				ZoneRedundancy: pulumi.String(notificationhubs.ZoneRedundancyPreferenceEnabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("5ktrial"),
 * 			Sku: &notificationhubs.SkuArgs{
 * 				Name: pulumi.String(notificationhubs.SkuNameStandard),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.notificationhubs.Namespace;
 * import com.pulumi.azurenative.notificationhubs.NamespaceArgs;
 * import com.pulumi.azurenative.notificationhubs.inputs.NamespacePropertiesArgs;
 * import com.pulumi.azurenative.notificationhubs.inputs.NetworkAclsArgs;
 * import com.pulumi.azurenative.notificationhubs.inputs.PublicInternetAuthorizationRuleArgs;
 * import com.pulumi.azurenative.notificationhubs.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespace = new Namespace("namespace", NamespaceArgs.builder()
 *             .location("South Central US")
 *             .namespaceName("nh-sdk-ns")
 *             .properties(NamespacePropertiesArgs.builder()
 *                 .networkAcls(NetworkAclsArgs.builder()
 *                     .ipRules(IpRuleArgs.builder()
 *                         .ipMask("185.48.100.00/24")
 *                         .rights(
 *                             "Manage",
 *                             "Send",
 *                             "Listen")
 *                         .build())
 *                     .publicNetworkRule(PublicInternetAuthorizationRuleArgs.builder()
 *                         .rights("Listen")
 *                         .build())
 *                     .build())
 *                 .zoneRedundancy("Enabled")
 *                 .build())
 *             .resourceGroupName("5ktrial")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .tier("Standard")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:notificationhubs:Namespace nh-sdk-ns /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property namespaceName Namespace name
 * @property properties Represents namespace properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The Sku description for a namespace
 * @property tags Resource tags.
 */
public data class NamespaceArgs(
    public val location: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val properties: Output<NamespacePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.NamespaceArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.NamespaceArgs =
        com.pulumi.azurenative.notificationhubs.NamespaceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var properties: Output<NamespacePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("egjsqijpickiatan")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Namespace name
     */
    @JvmName("anxyhgvqcocfpyyi")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Represents namespace properties.
     */
    @JvmName("nouoaoyxcbknatbu")
    public suspend fun properties(`value`: Output<NamespacePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vadxcswhacoopybx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Sku description for a namespace
     */
    @JvmName("xavdvonnfetydfbu")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("njghqfcxijejcbjt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fhtolsltnrqxedbk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Namespace name
     */
    @JvmName("djwrleqthrkiasrk")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Represents namespace properties.
     */
    @JvmName("bjcuypojosqufirp")
    public suspend fun properties(`value`: NamespacePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Represents namespace properties.
     */
    @JvmName("nbbaltjsmpukvktw")
    public suspend fun properties(argument: suspend NamespacePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = NamespacePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gmlxpgsopuxuxfpk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Sku description for a namespace
     */
    @JvmName("lapcysesvufafowd")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The Sku description for a namespace
     */
    @JvmName("ujmyvdodcnqbbaoe")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oxenywowspgjolja")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("uudtwbofcawricai")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        location = location,
        namespaceName = namespaceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
