@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin

import com.pulumi.azurenative.notificationhubs.NotificationHubArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.NotificationHubPropertiesArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.NotificationHubPropertiesArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Notification Hub Resource.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2014-09-01, 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
 * ## Example Usage
 * ### NotificationHubs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notificationHub = new AzureNative.NotificationHubs.NotificationHub("notificationHub", new()
 *     {
 *         Location = "eastus",
 *         NamespaceName = "nh-sdk-ns",
 *         NotificationHubName = "nh-sdk-hub",
 *         Properties = null,
 *         ResourceGroupName = "5ktrial",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/notificationhubs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := notificationhubs.NewNotificationHub(ctx, "notificationHub", &notificationhubs.NotificationHubArgs{
 * 			Location:            pulumi.String("eastus"),
 * 			NamespaceName:       pulumi.String("nh-sdk-ns"),
 * 			NotificationHubName: pulumi.String("nh-sdk-hub"),
 * 			Properties:          nil,
 * 			ResourceGroupName:   pulumi.String("5ktrial"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.notificationhubs.NotificationHub;
 * import com.pulumi.azurenative.notificationhubs.NotificationHubArgs;
 * import com.pulumi.azurenative.notificationhubs.inputs.NotificationHubPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notificationHub = new NotificationHub("notificationHub", NotificationHubArgs.builder()
 *             .location("eastus")
 *             .namespaceName("nh-sdk-ns")
 *             .notificationHubName("nh-sdk-hub")
 *             .properties()
 *             .resourceGroupName("5ktrial")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:notificationhubs:NotificationHub test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}
 * ```
 * @property location The geo-location where the resource lives
 * @property namespaceName Namespace name
 * @property notificationHubName Notification Hub name
 * @property properties NotificationHub properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The Sku description for a namespace
 * @property tags Resource tags.
 */
public data class NotificationHubArgs(
    public val location: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val notificationHubName: Output<String>? = null,
    public val properties: Output<NotificationHubPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.NotificationHubArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.NotificationHubArgs =
        com.pulumi.azurenative.notificationhubs.NotificationHubArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .notificationHubName(notificationHubName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NotificationHubArgs].
 */
@PulumiTagMarker
public class NotificationHubArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var notificationHubName: Output<String>? = null

    private var properties: Output<NotificationHubPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hdrnhninphvhhakw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Namespace name
     */
    @JvmName("faidkxksyqavbgyp")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Notification Hub name
     */
    @JvmName("anngmgkvvdytlspy")
    public suspend fun notificationHubName(`value`: Output<String>) {
        this.notificationHubName = value
    }

    /**
     * @param value NotificationHub properties.
     */
    @JvmName("ycjrjwfytkylecjk")
    public suspend fun properties(`value`: Output<NotificationHubPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uvtapnvnsierfqwr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Sku description for a namespace
     */
    @JvmName("lyprojwmyrwyrcti")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("waiwbdtybopbuvej")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mxaasidhlsivqpxk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Namespace name
     */
    @JvmName("iexfjoyprribkhjn")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Notification Hub name
     */
    @JvmName("aqxopwqebqvaihnu")
    public suspend fun notificationHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationHubName = mapped
    }

    /**
     * @param value NotificationHub properties.
     */
    @JvmName("esintgyrrorqcsor")
    public suspend fun properties(`value`: NotificationHubPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument NotificationHub properties.
     */
    @JvmName("mlucaoxcacgwkhde")
    public suspend fun properties(argument: suspend NotificationHubPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationHubPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ftdwusfepgfmyiab")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Sku description for a namespace
     */
    @JvmName("ciuoyexfklnpktcm")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The Sku description for a namespace
     */
    @JvmName("bvtetjyafqylmbhg")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("owndqbvtqulvhsww")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tpuxirexhiqpwroo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NotificationHubArgs = NotificationHubArgs(
        location = location,
        namespaceName = namespaceName,
        notificationHubName = notificationHubName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
