@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.AdmCredentialPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub AdmCredential.
 * @property authTokenUrl Gets or sets the URL of the authorization token.
 * @property clientId Gets or sets the client identifier.
 * @property clientSecret Gets or sets the credential secret access key.
 */
public data class AdmCredentialPropertiesArgs(
    public val authTokenUrl: Output<String>,
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.AdmCredentialPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.AdmCredentialPropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.AdmCredentialPropertiesArgs.builder()
            .authTokenUrl(authTokenUrl.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdmCredentialPropertiesArgs].
 */
@PulumiTagMarker
public class AdmCredentialPropertiesArgsBuilder internal constructor() {
    private var authTokenUrl: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    /**
     * @param value Gets or sets the URL of the authorization token.
     */
    @JvmName("axlwgnuobllnmkgw")
    public suspend fun authTokenUrl(`value`: Output<String>) {
        this.authTokenUrl = value
    }

    /**
     * @param value Gets or sets the client identifier.
     */
    @JvmName("qlybdmakxmecsise")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Gets or sets the credential secret access key.
     */
    @JvmName("aevarmijfglruxan")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Gets or sets the URL of the authorization token.
     */
    @JvmName("hhpuaiiurvdkrogp")
    public suspend fun authTokenUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authTokenUrl = mapped
    }

    /**
     * @param value Gets or sets the client identifier.
     */
    @JvmName("xubumtrxxirsnifp")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Gets or sets the credential secret access key.
     */
    @JvmName("xhuntrqdybuyyjdo")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    internal fun build(): AdmCredentialPropertiesArgs = AdmCredentialPropertiesArgs(
        authTokenUrl = authTokenUrl ?: throw PulumiNullFieldException("authTokenUrl"),
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
    )
}
