@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.BrowserCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub BrowserCredential.
 * @property properties Description of a NotificationHub BrowserCredential.
 */
public data class BrowserCredentialArgs(
    public val properties: Output<BrowserCredentialPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.BrowserCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.BrowserCredentialArgs =
        com.pulumi.azurenative.notificationhubs.inputs.BrowserCredentialArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BrowserCredentialArgs].
 */
@PulumiTagMarker
public class BrowserCredentialArgsBuilder internal constructor() {
    private var properties: Output<BrowserCredentialPropertiesArgs>? = null

    /**
     * @param value Description of a NotificationHub BrowserCredential.
     */
    @JvmName("ngsybrbdxuohchvb")
    public suspend fun properties(`value`: Output<BrowserCredentialPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Description of a NotificationHub BrowserCredential.
     */
    @JvmName("rdxwwnbcesxmxbnp")
    public suspend fun properties(`value`: BrowserCredentialPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Description of a NotificationHub BrowserCredential.
     */
    @JvmName("roorcgpptfhbtuyg")
    public suspend
    fun properties(argument: suspend BrowserCredentialPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BrowserCredentialPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): BrowserCredentialArgs = BrowserCredentialArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
