@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.ListNamespaceKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationRuleName Authorization Rule Name
 * @property namespaceName Namespace name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListNamespaceKeysPlainArgs(
    public val authorizationRuleName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.ListNamespaceKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.ListNamespaceKeysPlainArgs =
        com.pulumi.azurenative.notificationhubs.inputs.ListNamespaceKeysPlainArgs.builder()
            .authorizationRuleName(authorizationRuleName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListNamespaceKeysPlainArgs].
 */
@PulumiTagMarker
public class ListNamespaceKeysPlainArgsBuilder internal constructor() {
    private var authorizationRuleName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Authorization Rule Name
     */
    @JvmName("mkqrxkqfughbyajy")
    public suspend fun authorizationRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value Namespace name
     */
    @JvmName("kgqeksdkphyslvxw")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dksqpwcmgaxnjbvy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListNamespaceKeysPlainArgs = ListNamespaceKeysPlainArgs(
        authorizationRuleName = authorizationRuleName ?: throw
            PulumiNullFieldException("authorizationRuleName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
