@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.PnsCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Collection of Notification Hub or Notification Hub Namespace PNS credentials.
 * @property admCredential Description of a NotificationHub AdmCredential.
 * @property apnsCredential Description of a NotificationHub ApnsCredential.
 * @property baiduCredential Description of a NotificationHub BaiduCredential.
 * @property browserCredential Description of a NotificationHub BrowserCredential.
 * @property gcmCredential Description of a NotificationHub GcmCredential.
 * @property mpnsCredential Description of a NotificationHub MpnsCredential.
 * @property wnsCredential Description of a NotificationHub WnsCredential.
 * @property xiaomiCredential Description of a NotificationHub XiaomiCredential.
 */
public data class PnsCredentialsArgs(
    public val admCredential: Output<AdmCredentialArgs>? = null,
    public val apnsCredential: Output<ApnsCredentialArgs>? = null,
    public val baiduCredential: Output<BaiduCredentialArgs>? = null,
    public val browserCredential: Output<BrowserCredentialArgs>? = null,
    public val gcmCredential: Output<GcmCredentialArgs>? = null,
    public val mpnsCredential: Output<MpnsCredentialArgs>? = null,
    public val wnsCredential: Output<WnsCredentialArgs>? = null,
    public val xiaomiCredential: Output<XiaomiCredentialArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.PnsCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.PnsCredentialsArgs =
        com.pulumi.azurenative.notificationhubs.inputs.PnsCredentialsArgs.builder()
            .admCredential(admCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .apnsCredential(apnsCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .baiduCredential(baiduCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .browserCredential(browserCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .gcmCredential(gcmCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mpnsCredential(mpnsCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .wnsCredential(wnsCredential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .xiaomiCredential(
                xiaomiCredential?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PnsCredentialsArgs].
 */
@PulumiTagMarker
public class PnsCredentialsArgsBuilder internal constructor() {
    private var admCredential: Output<AdmCredentialArgs>? = null

    private var apnsCredential: Output<ApnsCredentialArgs>? = null

    private var baiduCredential: Output<BaiduCredentialArgs>? = null

    private var browserCredential: Output<BrowserCredentialArgs>? = null

    private var gcmCredential: Output<GcmCredentialArgs>? = null

    private var mpnsCredential: Output<MpnsCredentialArgs>? = null

    private var wnsCredential: Output<WnsCredentialArgs>? = null

    private var xiaomiCredential: Output<XiaomiCredentialArgs>? = null

    /**
     * @param value Description of a NotificationHub AdmCredential.
     */
    @JvmName("itvvmbfsfsicihaw")
    public suspend fun admCredential(`value`: Output<AdmCredentialArgs>) {
        this.admCredential = value
    }

    /**
     * @param value Description of a NotificationHub ApnsCredential.
     */
    @JvmName("xaglmxjtijjmfayl")
    public suspend fun apnsCredential(`value`: Output<ApnsCredentialArgs>) {
        this.apnsCredential = value
    }

    /**
     * @param value Description of a NotificationHub BaiduCredential.
     */
    @JvmName("topqyrqyirsulcwe")
    public suspend fun baiduCredential(`value`: Output<BaiduCredentialArgs>) {
        this.baiduCredential = value
    }

    /**
     * @param value Description of a NotificationHub BrowserCredential.
     */
    @JvmName("pxijbwacstkxdakb")
    public suspend fun browserCredential(`value`: Output<BrowserCredentialArgs>) {
        this.browserCredential = value
    }

    /**
     * @param value Description of a NotificationHub GcmCredential.
     */
    @JvmName("fffxswopsajxvdvt")
    public suspend fun gcmCredential(`value`: Output<GcmCredentialArgs>) {
        this.gcmCredential = value
    }

    /**
     * @param value Description of a NotificationHub MpnsCredential.
     */
    @JvmName("lnlmaidbknfcbmmg")
    public suspend fun mpnsCredential(`value`: Output<MpnsCredentialArgs>) {
        this.mpnsCredential = value
    }

    /**
     * @param value Description of a NotificationHub WnsCredential.
     */
    @JvmName("mskrxctlkqmtyptn")
    public suspend fun wnsCredential(`value`: Output<WnsCredentialArgs>) {
        this.wnsCredential = value
    }

    /**
     * @param value Description of a NotificationHub XiaomiCredential.
     */
    @JvmName("comsbhftcutdyogq")
    public suspend fun xiaomiCredential(`value`: Output<XiaomiCredentialArgs>) {
        this.xiaomiCredential = value
    }

    /**
     * @param value Description of a NotificationHub AdmCredential.
     */
    @JvmName("dtcswvluyomvhcee")
    public suspend fun admCredential(`value`: AdmCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.admCredential = mapped
    }

    /**
     * @param argument Description of a NotificationHub AdmCredential.
     */
    @JvmName("hdtmadxqatlsbdgk")
    public suspend fun admCredential(argument: suspend AdmCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = AdmCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.admCredential = mapped
    }

    /**
     * @param value Description of a NotificationHub ApnsCredential.
     */
    @JvmName("cbcqyqohifboygdn")
    public suspend fun apnsCredential(`value`: ApnsCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apnsCredential = mapped
    }

    /**
     * @param argument Description of a NotificationHub ApnsCredential.
     */
    @JvmName("sknhhwhrhlhdxhgr")
    public suspend fun apnsCredential(argument: suspend ApnsCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = ApnsCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apnsCredential = mapped
    }

    /**
     * @param value Description of a NotificationHub BaiduCredential.
     */
    @JvmName("krxwhfvxypitjppn")
    public suspend fun baiduCredential(`value`: BaiduCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baiduCredential = mapped
    }

    /**
     * @param argument Description of a NotificationHub BaiduCredential.
     */
    @JvmName("dpwgovofnfunkhrm")
    public suspend fun baiduCredential(argument: suspend BaiduCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = BaiduCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.baiduCredential = mapped
    }

    /**
     * @param value Description of a NotificationHub BrowserCredential.
     */
    @JvmName("gtxgbtjifsatyxou")
    public suspend fun browserCredential(`value`: BrowserCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.browserCredential = mapped
    }

    /**
     * @param argument Description of a NotificationHub BrowserCredential.
     */
    @JvmName("jbgaffycgpeddkvt")
    public suspend fun browserCredential(argument: suspend BrowserCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = BrowserCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.browserCredential = mapped
    }

    /**
     * @param value Description of a NotificationHub GcmCredential.
     */
    @JvmName("jxxfjtgfpehuvmxe")
    public suspend fun gcmCredential(`value`: GcmCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gcmCredential = mapped
    }

    /**
     * @param argument Description of a NotificationHub GcmCredential.
     */
    @JvmName("kfjfucixsemoagkx")
    public suspend fun gcmCredential(argument: suspend GcmCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = GcmCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gcmCredential = mapped
    }

    /**
     * @param value Description of a NotificationHub MpnsCredential.
     */
    @JvmName("ehiurwudufpvfrdc")
    public suspend fun mpnsCredential(`value`: MpnsCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mpnsCredential = mapped
    }

    /**
     * @param argument Description of a NotificationHub MpnsCredential.
     */
    @JvmName("dfcddvreffejjnub")
    public suspend fun mpnsCredential(argument: suspend MpnsCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = MpnsCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mpnsCredential = mapped
    }

    /**
     * @param value Description of a NotificationHub WnsCredential.
     */
    @JvmName("etoeiwsnovgvylvw")
    public suspend fun wnsCredential(`value`: WnsCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wnsCredential = mapped
    }

    /**
     * @param argument Description of a NotificationHub WnsCredential.
     */
    @JvmName("lrygxqihdgqqjpts")
    public suspend fun wnsCredential(argument: suspend WnsCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = WnsCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.wnsCredential = mapped
    }

    /**
     * @param value Description of a NotificationHub XiaomiCredential.
     */
    @JvmName("swiivletoqtdqvhi")
    public suspend fun xiaomiCredential(`value`: XiaomiCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xiaomiCredential = mapped
    }

    /**
     * @param argument Description of a NotificationHub XiaomiCredential.
     */
    @JvmName("ehgmihaamkkivihi")
    public suspend fun xiaomiCredential(argument: suspend XiaomiCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = XiaomiCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.xiaomiCredential = mapped
    }

    internal fun build(): PnsCredentialsArgs = PnsCredentialsArgs(
        admCredential = admCredential,
        apnsCredential = apnsCredential,
        baiduCredential = baiduCredential,
        browserCredential = browserCredential,
        gcmCredential = gcmCredential,
        mpnsCredential = mpnsCredential,
        wnsCredential = wnsCredential,
        xiaomiCredential = xiaomiCredential,
    )
}
