@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Response for POST requests that return single SharedAccessAuthorizationRule.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location Deprecated - only for compatibility.
 * @property name The name of the resource
 * @property properties SharedAccessAuthorizationRule properties.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Deprecated - only for compatibility.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNotificationHubAuthorizationRuleResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: SharedAccessAuthorizationRulePropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.GetNotificationHubAuthorizationRuleResult):
            GetNotificationHubAuthorizationRuleResult = GetNotificationHubAuthorizationRuleResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.notificationhubs.kotlin.outputs.SharedAccessAuthorizationRulePropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.notificationhubs.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
