@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of network authorization rules.
 * @property ipRules List of IP rules.
 * @property publicNetworkRule A default (public Internet) network authorization rule, which contains rights if no other network rule matches.
 */
public data class NetworkAclsResponse(
    public val ipRules: List<IpRuleResponse>? = null,
    public val publicNetworkRule: PublicInternetAuthorizationRuleResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.NetworkAclsResponse):
            NetworkAclsResponse = NetworkAclsResponse(
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.IpRuleResponse.Companion.toKotlin(args0)
                })
            }),
            publicNetworkRule = javaType.publicNetworkRule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.PublicInternetAuthorizationRuleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
