@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NotificationHub properties.
 * @property admCredential Description of a NotificationHub AdmCredential.
 * @property apnsCredential Description of a NotificationHub ApnsCredential.
 * @property authorizationRules Gets or sets the AuthorizationRules of the created NotificationHub
 * @property baiduCredential Description of a NotificationHub BaiduCredential.
 * @property browserCredential Description of a NotificationHub BrowserCredential.
 * @property dailyMaxActiveDevices
 * @property gcmCredential Description of a NotificationHub GcmCredential.
 * @property mpnsCredential Description of a NotificationHub MpnsCredential.
 * @property name Gets or sets the NotificationHub name.
 * @property registrationTtl Gets or sets the RegistrationTtl of the created NotificationHub
 * @property wnsCredential Description of a NotificationHub WnsCredential.
 * @property xiaomiCredential Description of a NotificationHub XiaomiCredential.
 */
public data class NotificationHubPropertiesResponse(
    public val admCredential: AdmCredentialResponse? = null,
    public val apnsCredential: ApnsCredentialResponse? = null,
    public val authorizationRules: List<SharedAccessAuthorizationRulePropertiesResponse>,
    public val baiduCredential: BaiduCredentialResponse? = null,
    public val browserCredential: BrowserCredentialResponse? = null,
    public val dailyMaxActiveDevices: Double,
    public val gcmCredential: GcmCredentialResponse? = null,
    public val mpnsCredential: MpnsCredentialResponse? = null,
    public val name: String? = null,
    public val registrationTtl: String? = null,
    public val wnsCredential: WnsCredentialResponse? = null,
    public val xiaomiCredential: XiaomiCredentialResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.NotificationHubPropertiesResponse):
            NotificationHubPropertiesResponse = NotificationHubPropertiesResponse(
            admCredential = javaType.admCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.AdmCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            apnsCredential = javaType.apnsCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.ApnsCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            authorizationRules = javaType.authorizationRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.SharedAccessAuthorizationRulePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            baiduCredential = javaType.baiduCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.BaiduCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            browserCredential = javaType.browserCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.BrowserCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dailyMaxActiveDevices = javaType.dailyMaxActiveDevices(),
            gcmCredential = javaType.gcmCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.GcmCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mpnsCredential = javaType.mpnsCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.MpnsCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            registrationTtl = javaType.registrationTtl().map({ args0 -> args0 }).orElse(null),
            wnsCredential = javaType.wnsCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.WnsCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            xiaomiCredential = javaType.xiaomiCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.XiaomiCredentialResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
