@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.HyperVSiteArgs.builder
import com.pulumi.azurenative.offazure.kotlin.inputs.SitePropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SitePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Site REST Resource.
 * Azure REST API version: 2020-07-07. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Create Hyper-V site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hyperVSite = new AzureNative.OffAzure.HyperVSite("hyperVSite", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.OffAzure.Inputs.SitePropertiesArgs
 *         {
 *             ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *             {
 *                 AadAuthority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ApplicationId = "e9f013df-2a2a-4871-b766-e79867f30348",
 *                 Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp",
 *                 ObjectId = "2cd492bc-7ef3-4ee0-b301-59a88108b47b",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         ResourceGroupName = "pajindTest",
 *         SiteName = "appliance1e39site",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHyperVSite(ctx, "hyperVSite", &offazure.HyperVSiteArgs{
 * 			Location: pulumi.String("eastus"),
 * 			Properties: &offazure.SitePropertiesArgs{
 * 				ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 					AadAuthority:  pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ApplicationId: pulumi.String("e9f013df-2a2a-4871-b766-e79867f30348"),
 * 					Audience:      pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp"),
 * 					ObjectId:      pulumi.String("2cd492bc-7ef3-4ee0-b301-59a88108b47b"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("pajindTest"),
 * 			SiteName:          pulumi.String("appliance1e39site"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HyperVSite;
 * import com.pulumi.azurenative.offazure.HyperVSiteArgs;
 * import com.pulumi.azurenative.offazure.inputs.SitePropertiesArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hyperVSite = new HyperVSite("hyperVSite", HyperVSiteArgs.builder()
 *             .location("eastus")
 *             .properties(SitePropertiesArgs.builder()
 *                 .servicePrincipalIdentityDetails(SiteSpnPropertiesArgs.builder()
 *                     .aadAuthority("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .applicationId("e9f013df-2a2a-4871-b766-e79867f30348")
 *                     .audience("https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp")
 *                     .objectId("2cd492bc-7ef3-4ee0-b301-59a88108b47b")
 *                     .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("pajindTest")
 *             .siteName("appliance1e39site")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:HyperVSite appliance1e39site /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/HyperVSites/{siteName}
 * ```
 * @property eTag eTag for concurrency control.
 * @property location Azure location in which Sites is created.
 * @property name Name of the Hyper-V site.
 * @property properties Nested properties of Hyper-V site.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name.
 * @property tags
 */
public data class HyperVSiteArgs(
    public val eTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<SitePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.HyperVSiteArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.HyperVSiteArgs =
        com.pulumi.azurenative.offazure.HyperVSiteArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [HyperVSiteArgs].
 */
@PulumiTagMarker
public class HyperVSiteArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<SitePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value eTag for concurrency control.
     */
    @JvmName("hlyswtwemuplluoh")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Azure location in which Sites is created.
     */
    @JvmName("qwukgftxpdcssehd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Hyper-V site.
     */
    @JvmName("kubobetaogvyrtxs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Nested properties of Hyper-V site.
     */
    @JvmName("tdigpamkweuvyuqm")
    public suspend fun properties(`value`: Output<SitePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fmuvkumifotsjcbt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site name.
     */
    @JvmName("qjwewnymohstkiij")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value
     */
    @JvmName("pjdjblyyshrlpqny")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value eTag for concurrency control.
     */
    @JvmName("ofacytxknqrdfkcb")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Azure location in which Sites is created.
     */
    @JvmName("sjtprddjcgqcojao")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Hyper-V site.
     */
    @JvmName("ofvdyjuhtdqtlsdx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Nested properties of Hyper-V site.
     */
    @JvmName("mhkxiiymcaullvou")
    public suspend fun properties(`value`: SitePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Nested properties of Hyper-V site.
     */
    @JvmName("jjxbximqgakuhitt")
    public suspend fun properties(argument: suspend SitePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SitePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ftcwvgxewvbwocwu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name.
     */
    @JvmName("lmrqeftqkidskhwi")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value
     */
    @JvmName("bdltmmaecjekwwmt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("yqpaadnorjemwdop")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): HyperVSiteArgs = HyperVSiteArgs(
        eTag = eTag,
        location = location,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
        tags = tags,
    )
}
