@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.HealthErrorDetailsResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.offazure.kotlin.outputs.HealthErrorDetailsResponse.Companion.toKotlin as healthErrorDetailsResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HypervClusterControllerCluster].
 */
@PulumiTagMarker
public class HypervClusterControllerClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HypervClusterControllerClusterArgs = HypervClusterControllerClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HypervClusterControllerClusterArgsBuilder.() -> Unit) {
        val builder = HypervClusterControllerClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HypervClusterControllerCluster {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.HypervClusterControllerCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HypervClusterControllerCluster(builtJavaResource)
    }
}

/**
 * A cluster resource belonging to a site resource.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### HypervClusterController_CreateCluster_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervClusterControllerCluster = new AzureNative.OffAzure.HypervClusterControllerCluster("hypervClusterControllerCluster", new()
 *     {
 *         ClusterName = "v5285",
 *         Fqdn = "lyqquicmqfagukcwfquemrkrexic",
 *         HostFqdnList = new[]
 *         {
 *             "frozqzatdahnwlccznpmw",
 *         },
 *         ProvisioningState = AzureNative.OffAzure.ProvisioningState.Created,
 *         ResourceGroupName = "rgmigrate",
 *         RunAsAccountId = "valugnnrofauhagzzxksfjbcwuqhue",
 *         SiteName = "224qC-GNR",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervClusterControllerCluster(ctx, "hypervClusterControllerCluster", &offazure.HypervClusterControllerClusterArgs{
 * 			ClusterName: pulumi.String("v5285"),
 * 			Fqdn:        pulumi.String("lyqquicmqfagukcwfquemrkrexic"),
 * 			HostFqdnList: pulumi.StringArray{
 * 				pulumi.String("frozqzatdahnwlccznpmw"),
 * 			},
 * 			ProvisioningState: pulumi.String(offazure.ProvisioningStateCreated),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			RunAsAccountId:    pulumi.String("valugnnrofauhagzzxksfjbcwuqhue"),
 * 			SiteName:          pulumi.String("224qC-GNR"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervClusterControllerCluster;
 * import com.pulumi.azurenative.offazure.HypervClusterControllerClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervClusterControllerCluster = new HypervClusterControllerCluster("hypervClusterControllerCluster", HypervClusterControllerClusterArgs.builder()
 *             .clusterName("v5285")
 *             .fqdn("lyqquicmqfagukcwfquemrkrexic")
 *             .hostFqdnList("frozqzatdahnwlccznpmw")
 *             .provisioningState("Created")
 *             .resourceGroupName("rgmigrate")
 *             .runAsAccountId("valugnnrofauhagzzxksfjbcwuqhue")
 *             .siteName("224qC-GNR")
 *             .build());
 *     }
 * }
 * ```
 * ### HypervClusterController_CreateCluster_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervClusterControllerCluster = new AzureNative.OffAzure.HypervClusterControllerCluster("hypervClusterControllerCluster", new()
 *     {
 *         ClusterName = "-18--O4iS57-729MV9PCErt",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "--xY37--V518",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervClusterControllerCluster(ctx, "hypervClusterControllerCluster", &offazure.HypervClusterControllerClusterArgs{
 * 			ClusterName:       pulumi.String("-18--O4iS57-729MV9PCErt"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("--xY37--V518"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervClusterControllerCluster;
 * import com.pulumi.azurenative.offazure.HypervClusterControllerClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervClusterControllerCluster = new HypervClusterControllerCluster("hypervClusterControllerCluster", HypervClusterControllerClusterArgs.builder()
 *             .clusterName("-18--O4iS57-729MV9PCErt")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("--xY37--V518")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:HypervClusterControllerCluster jtuzcezhvbmfpe /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/hypervSites/{siteName}/clusters/{clusterName}
 * ```
 */
public class HypervClusterControllerCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.HypervClusterControllerCluster,
) : KotlinCustomResource(javaResource, HypervClusterControllerClusterMapper) {
    /**
     * Gets the timestamp marking Hyper-V cluster creation.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the errors.
     */
    public val errors: Output<List<HealthErrorDetailsResponse>>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    healthErrorDetailsResponseToKotlin(args0)
                })
            })
        })

    /**
     * Gets or sets the FQDN/IPAddress of the Hyper-V cluster.
     */
    public val fqdn: Output<String>?
        get() = javaResource.fqdn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the functional level of the Hyper-V cluster.
     */
    public val functionalLevel: Output<Int>
        get() = javaResource.functionalLevel().applyValue({ args0 -> args0 })

    /**
     * Gets or sets list of hosts (FQDN) currently being tracked by the cluster.
     */
    public val hostFqdnList: Output<List<String>>?
        get() = javaResource.hostFqdnList().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets Run as account ID of the Hyper-V cluster.
     */
    public val runAsAccountId: Output<String>?
        get() = javaResource.runAsAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the status of the Hyper-V cluster.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets the timestamp marking last updated on the Hyper-V cluster.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object HypervClusterControllerClusterMapper : ResourceMapper<HypervClusterControllerCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.HypervClusterControllerCluster::class == javaResource::class

    override fun map(javaResource: Resource): HypervClusterControllerCluster =
        HypervClusterControllerCluster(
            javaResource as
                com.pulumi.azurenative.offazure.HypervClusterControllerCluster,
        )
}

/**
 * @see [HypervClusterControllerCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HypervClusterControllerCluster].
 */
public suspend fun hypervClusterControllerCluster(
    name: String,
    block: suspend HypervClusterControllerClusterResourceBuilder.() -> Unit,
):
    HypervClusterControllerCluster {
    val builder = HypervClusterControllerClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HypervClusterControllerCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hypervClusterControllerCluster(name: String): HypervClusterControllerCluster {
    val builder = HypervClusterControllerClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
