@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.HypervClusterControllerClusterArgs.builder
import com.pulumi.azurenative.offazure.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A cluster resource belonging to a site resource.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### HypervClusterController_CreateCluster_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervClusterControllerCluster = new AzureNative.OffAzure.HypervClusterControllerCluster("hypervClusterControllerCluster", new()
 *     {
 *         ClusterName = "v5285",
 *         Fqdn = "lyqquicmqfagukcwfquemrkrexic",
 *         HostFqdnList = new[]
 *         {
 *             "frozqzatdahnwlccznpmw",
 *         },
 *         ProvisioningState = AzureNative.OffAzure.ProvisioningState.Created,
 *         ResourceGroupName = "rgmigrate",
 *         RunAsAccountId = "valugnnrofauhagzzxksfjbcwuqhue",
 *         SiteName = "224qC-GNR",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervClusterControllerCluster(ctx, "hypervClusterControllerCluster", &offazure.HypervClusterControllerClusterArgs{
 * 			ClusterName: pulumi.String("v5285"),
 * 			Fqdn:        pulumi.String("lyqquicmqfagukcwfquemrkrexic"),
 * 			HostFqdnList: pulumi.StringArray{
 * 				pulumi.String("frozqzatdahnwlccznpmw"),
 * 			},
 * 			ProvisioningState: pulumi.String(offazure.ProvisioningStateCreated),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			RunAsAccountId:    pulumi.String("valugnnrofauhagzzxksfjbcwuqhue"),
 * 			SiteName:          pulumi.String("224qC-GNR"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervClusterControllerCluster;
 * import com.pulumi.azurenative.offazure.HypervClusterControllerClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervClusterControllerCluster = new HypervClusterControllerCluster("hypervClusterControllerCluster", HypervClusterControllerClusterArgs.builder()
 *             .clusterName("v5285")
 *             .fqdn("lyqquicmqfagukcwfquemrkrexic")
 *             .hostFqdnList("frozqzatdahnwlccznpmw")
 *             .provisioningState("Created")
 *             .resourceGroupName("rgmigrate")
 *             .runAsAccountId("valugnnrofauhagzzxksfjbcwuqhue")
 *             .siteName("224qC-GNR")
 *             .build());
 *     }
 * }
 * ```
 * ### HypervClusterController_CreateCluster_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervClusterControllerCluster = new AzureNative.OffAzure.HypervClusterControllerCluster("hypervClusterControllerCluster", new()
 *     {
 *         ClusterName = "-18--O4iS57-729MV9PCErt",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "--xY37--V518",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervClusterControllerCluster(ctx, "hypervClusterControllerCluster", &offazure.HypervClusterControllerClusterArgs{
 * 			ClusterName:       pulumi.String("-18--O4iS57-729MV9PCErt"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("--xY37--V518"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervClusterControllerCluster;
 * import com.pulumi.azurenative.offazure.HypervClusterControllerClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervClusterControllerCluster = new HypervClusterControllerCluster("hypervClusterControllerCluster", HypervClusterControllerClusterArgs.builder()
 *             .clusterName("-18--O4iS57-729MV9PCErt")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("--xY37--V518")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:HypervClusterControllerCluster jtuzcezhvbmfpe /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/hypervSites/{siteName}/clusters/{clusterName}
 * ```
 * @property clusterName  Cluster ARM name
 * @property fqdn Gets or sets the FQDN/IPAddress of the Hyper-V cluster.
 * @property hostFqdnList Gets or sets list of hosts (FQDN) currently being tracked by the cluster.
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property runAsAccountId Gets or sets Run as account ID of the Hyper-V cluster.
 * @property siteName Site name
 */
public data class HypervClusterControllerClusterArgs(
    public val clusterName: Output<String>? = null,
    public val fqdn: Output<String>? = null,
    public val hostFqdnList: Output<List<String>>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runAsAccountId: Output<String>? = null,
    public val siteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.HypervClusterControllerClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.HypervClusterControllerClusterArgs =
        com.pulumi.azurenative.offazure.HypervClusterControllerClusterArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .hostFqdnList(hostFqdnList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runAsAccountId(runAsAccountId?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HypervClusterControllerClusterArgs].
 */
@PulumiTagMarker
public class HypervClusterControllerClusterArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var fqdn: Output<String>? = null

    private var hostFqdnList: Output<List<String>>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var runAsAccountId: Output<String>? = null

    private var siteName: Output<String>? = null

    /**
     * @param value  Cluster ARM name
     */
    @JvmName("hboyrmnogershcgd")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Gets or sets the FQDN/IPAddress of the Hyper-V cluster.
     */
    @JvmName("giforkddbagfjcyv")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value Gets or sets list of hosts (FQDN) currently being tracked by the cluster.
     */
    @JvmName("myjptnsmqyjhdlnc")
    public suspend fun hostFqdnList(`value`: Output<List<String>>) {
        this.hostFqdnList = value
    }

    @JvmName("pwcenmqsnluxjsdh")
    public suspend fun hostFqdnList(vararg values: Output<String>) {
        this.hostFqdnList = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets list of hosts (FQDN) currently being tracked by the cluster.
     */
    @JvmName("dgwxnvcbvcempurh")
    public suspend fun hostFqdnList(values: List<Output<String>>) {
        this.hostFqdnList = Output.all(values)
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("auannetjhmftmdct")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ljnnisnqrhwkoglw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets Run as account ID of the Hyper-V cluster.
     */
    @JvmName("kjyhvaagsugfeing")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value Site name
     */
    @JvmName("iahgoqlbmifaikvo")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value  Cluster ARM name
     */
    @JvmName("ajegslajjfavphpc")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Gets or sets the FQDN/IPAddress of the Hyper-V cluster.
     */
    @JvmName("oexlyxxvdttrsnnu")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value Gets or sets list of hosts (FQDN) currently being tracked by the cluster.
     */
    @JvmName("ppcpkahwvvlvafpc")
    public suspend fun hostFqdnList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostFqdnList = mapped
    }

    /**
     * @param values Gets or sets list of hosts (FQDN) currently being tracked by the cluster.
     */
    @JvmName("vsysrnfxxyftpjaj")
    public suspend fun hostFqdnList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostFqdnList = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("vkukpldaeawcccub")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("jngbxyffjbcyhnta")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("ibyjevagkamkreyk")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gorkamgfyalxgprc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets Run as account ID of the Hyper-V cluster.
     */
    @JvmName("kytvvyhnamskxmtv")
    public suspend fun runAsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("isyyyoqwrluxyoyd")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    internal fun build(): HypervClusterControllerClusterArgs = HypervClusterControllerClusterArgs(
        clusterName = clusterName,
        fqdn = fqdn,
        hostFqdnList = hostFqdnList,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        runAsAccountId = runAsAccountId,
        siteName = siteName,
    )
}
