@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.HypervSitesControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAgentPropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAgentPropertiesArgsBuilder
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteSpnPropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteSpnPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A HyperV SiteResource
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### HypervSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervSitesController = new AzureNative.OffAzure.HypervSitesController("hypervSitesController", new()
 *     {
 *         AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *         {
 *             KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *             KeyVaultUri = "qizphgqwage",
 *         },
 *         ApplianceName = "jnpsjguxuzuxbhasiqfijf",
 *         DiscoverySolutionId = "yxajidsykozchjkuxj",
 *         Location = "sctymxdndonxgejdhi",
 *         ProvisioningState = AzureNative.OffAzure.ProvisioningState.Created,
 *         ResourceGroupName = "rgmigrate",
 *         ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *         {
 *             AadAuthority = "yanzipdww",
 *             ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *             Audience = "oepwfaozztzvegmzvswafvotj",
 *             ObjectId = "tqrjngpgxnnto",
 *             RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *             TenantId = "vesmyhu",
 *         },
 *         SiteName = "692-u-93F93",
 *         Tags =
 *         {
 *             { "key9741", "fdbzykkpvhnhsrhiam" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervSitesController(ctx, "hypervSitesController", &offazure.HypervSitesControllerArgs{
 * 			AgentDetails: &offazure.SiteAgentPropertiesArgs{
 * 				KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 				KeyVaultUri: pulumi.String("qizphgqwage"),
 * 			},
 * 			ApplianceName:       pulumi.String("jnpsjguxuzuxbhasiqfijf"),
 * 			DiscoverySolutionId: pulumi.String("yxajidsykozchjkuxj"),
 * 			Location:            pulumi.String("sctymxdndonxgejdhi"),
 * 			ProvisioningState:   pulumi.String(offazure.ProvisioningStateCreated),
 * 			ResourceGroupName:   pulumi.String("rgmigrate"),
 * 			ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 				AadAuthority:  pulumi.String("yanzipdww"),
 * 				ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 				Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 				ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 				RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 				TenantId:      pulumi.String("vesmyhu"),
 * 			},
 * 			SiteName: pulumi.String("692-u-93F93"),
 * 			Tags: pulumi.StringMap{
 * 				"key9741": pulumi.String("fdbzykkpvhnhsrhiam"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervSitesController;
 * import com.pulumi.azurenative.offazure.HypervSitesControllerArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteAgentPropertiesArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervSitesController = new HypervSitesController("hypervSitesController", HypervSitesControllerArgs.builder()
 *             .agentDetails(SiteAgentPropertiesArgs.builder()
 *                 .keyVaultId("awxurtbjmofxuciewsqfgpkccpzw")
 *                 .keyVaultUri("qizphgqwage")
 *                 .build())
 *             .applianceName("jnpsjguxuzuxbhasiqfijf")
 *             .discoverySolutionId("yxajidsykozchjkuxj")
 *             .location("sctymxdndonxgejdhi")
 *             .provisioningState("Created")
 *             .resourceGroupName("rgmigrate")
 *             .servicePrincipalIdentityDetails(SiteSpnPropertiesArgs.builder()
 *                 .aadAuthority("yanzipdww")
 *                 .applicationId("tspgrujepxyxuprkqvfuqbbjrweeqa")
 *                 .audience("oepwfaozztzvegmzvswafvotj")
 *                 .objectId("tqrjngpgxnnto")
 *                 .rawCertData("dotvgkslkmsgvtekgojnhcdrryk")
 *                 .tenantId("vesmyhu")
 *                 .build())
 *             .siteName("692-u-93F93")
 *             .tags(Map.of("key9741", "fdbzykkpvhnhsrhiam"))
 *             .build());
 *     }
 * }
 * ```
 * ### HypervSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervSitesController = new AzureNative.OffAzure.HypervSitesController("hypervSitesController", new()
 *     {
 *         Location = "sctymxdndonxgejdhi",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "Y-C-7---V49GV-058XE-6P5",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervSitesController(ctx, "hypervSitesController", &offazure.HypervSitesControllerArgs{
 * 			Location:          pulumi.String("sctymxdndonxgejdhi"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("Y-C-7---V49GV-058XE-6P5"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervSitesController;
 * import com.pulumi.azurenative.offazure.HypervSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervSitesController = new HypervSitesController("hypervSitesController", HypervSitesControllerArgs.builder()
 *             .location("sctymxdndonxgejdhi")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("Y-C-7---V49GV-058XE-6P5")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:HypervSitesController xnxtdkrodsftjeebdwdkgpneqtzf /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/hypervSites/{siteName}
 * ```
 * @property agentDetails Gets or sets the on-premises agent details.
 * @property applianceName Gets or sets the Appliance Name.
 * @property discoverySolutionId Gets or sets the ARM ID of migration hub solution for SDS.
 * @property location The geo-location where the resource lives
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property servicePrincipalIdentityDetails Gets or sets the service principal identity details used by agent for
 * communication
 *             to the service.
 * @property siteName Site name
 * @property tags Resource tags.
 */
public data class HypervSitesControllerArgs(
    public val agentDetails: Output<SiteAgentPropertiesArgs>? = null,
    public val applianceName: Output<String>? = null,
    public val discoverySolutionId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null,
    public val siteName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.HypervSitesControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.HypervSitesControllerArgs =
        com.pulumi.azurenative.offazure.HypervSitesControllerArgs.builder()
            .agentDetails(agentDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .applianceName(applianceName?.applyValue({ args0 -> args0 }))
            .discoverySolutionId(discoverySolutionId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .servicePrincipalIdentityDetails(
                servicePrincipalIdentityDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [HypervSitesControllerArgs].
 */
@PulumiTagMarker
public class HypervSitesControllerArgsBuilder internal constructor() {
    private var agentDetails: Output<SiteAgentPropertiesArgs>? = null

    private var applianceName: Output<String>? = null

    private var discoverySolutionId: Output<String>? = null

    private var location: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null

    private var siteName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Gets or sets the on-premises agent details.
     */
    @JvmName("mycntesgxhngiscf")
    public suspend fun agentDetails(`value`: Output<SiteAgentPropertiesArgs>) {
        this.agentDetails = value
    }

    /**
     * @param value Gets or sets the Appliance Name.
     */
    @JvmName("xhylbdoowifixork")
    public suspend fun applianceName(`value`: Output<String>) {
        this.applianceName = value
    }

    /**
     * @param value Gets or sets the ARM ID of migration hub solution for SDS.
     */
    @JvmName("asotudpqckldimfj")
    public suspend fun discoverySolutionId(`value`: Output<String>) {
        this.discoverySolutionId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rvhdxfujrtqdikcm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("lxfxjoculkeqrjkt")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hrvxswayejqjgalv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    @JvmName("iiwluxoepnprppsi")
    public suspend fun servicePrincipalIdentityDetails(`value`: Output<SiteSpnPropertiesArgs>) {
        this.servicePrincipalIdentityDetails = value
    }

    /**
     * @param value Site name
     */
    @JvmName("itiqpmyerakfsxud")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gbpltiohtfqhsdpe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the on-premises agent details.
     */
    @JvmName("peegnxenurihywkk")
    public suspend fun agentDetails(`value`: SiteAgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentDetails = mapped
    }

    /**
     * @param argument Gets or sets the on-premises agent details.
     */
    @JvmName("ynmkrrbrwxnospgc")
    public suspend fun agentDetails(argument: suspend SiteAgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteAgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentDetails = mapped
    }

    /**
     * @param value Gets or sets the Appliance Name.
     */
    @JvmName("yyebdcgjuahgtrgf")
    public suspend fun applianceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applianceName = mapped
    }

    /**
     * @param value Gets or sets the ARM ID of migration hub solution for SDS.
     */
    @JvmName("qqtvycavgsfifacm")
    public suspend fun discoverySolutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySolutionId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lcofqwhihjwwnnab")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("fcgjmdlmadxjjlnb")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("hrgybwpvnafsebvp")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("mejkrfbmcqlvcton")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dnugwjjucjbevujf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    @JvmName("wqekjcdtxtomnouo")
    public suspend fun servicePrincipalIdentityDetails(`value`: SiteSpnPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalIdentityDetails = mapped
    }

    /**
     * @param argument Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    @JvmName("wawxtobiupxbwfbh")
    public suspend
    fun servicePrincipalIdentityDetails(argument: suspend SiteSpnPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteSpnPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipalIdentityDetails = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("npjqwwmmlqxpiyrx")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tiootmxkfpndqcex")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wxmrjqbnbvkecwle")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): HypervSitesControllerArgs = HypervSitesControllerArgs(
        agentDetails = agentDetails,
        applianceName = applianceName,
        discoverySolutionId = discoverySolutionId,
        location = location,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        servicePrincipalIdentityDetails = servicePrincipalIdentityDetails,
        siteName = siteName,
        tags = tags,
    )
}
