@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.PrivateEndpointConnectionControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * REST model used to encapsulate Private Link properties for tracked resources.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnectionController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionController = new AzureNative.OffAzure.PrivateEndpointConnectionController("privateEndpointConnectionController", new()
 *     {
 *         PeConnectionName = "-KF3-86-D3L-8M",
 *         PrivateLinkServiceConnectionState = new AzureNative.OffAzure.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "swxghzuajrasojk",
 *             Description = "ljdykrrhmzi",
 *             Status = AzureNative.OffAzure.PrivateLinkServiceConnectionStateStatus.Approved,
 *         },
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "LuBO2I1-B85pJ1BZ251",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewPrivateEndpointConnectionController(ctx, "privateEndpointConnectionController", &offazure.PrivateEndpointConnectionControllerArgs{
 * 			PeConnectionName: pulumi.String("-KF3-86-D3L-8M"),
 * 			PrivateLinkServiceConnectionState: &offazure.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("swxghzuajrasojk"),
 * 				Description:     pulumi.String("ljdykrrhmzi"),
 * 				Status:          pulumi.String(offazure.PrivateLinkServiceConnectionStateStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("LuBO2I1-B85pJ1BZ251"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnectionController;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnectionControllerArgs;
 * import com.pulumi.azurenative.offazure.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionController = new PrivateEndpointConnectionController("privateEndpointConnectionController", PrivateEndpointConnectionControllerArgs.builder()
 *             .peConnectionName("-KF3-86-D3L-8M")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .actionsRequired("swxghzuajrasojk")
 *                 .description("ljdykrrhmzi")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("rgmigrate")
 *             .siteName("LuBO2I1-B85pJ1BZ251")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateEndpointConnectionController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionController = new AzureNative.OffAzure.PrivateEndpointConnectionController("privateEndpointConnectionController", new()
 *     {
 *         PeConnectionName = "-p-U2",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "1--tOY-47Q-X95WC3d-U",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewPrivateEndpointConnectionController(ctx, "privateEndpointConnectionController", &offazure.PrivateEndpointConnectionControllerArgs{
 * 			PeConnectionName:  pulumi.String("-p-U2"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("1--tOY-47Q-X95WC3d-U"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnectionController;
 * import com.pulumi.azurenative.offazure.PrivateEndpointConnectionControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionController = new PrivateEndpointConnectionController("privateEndpointConnectionController", PrivateEndpointConnectionControllerArgs.builder()
 *             .peConnectionName("-p-U2")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("1--tOY-47Q-X95WC3d-U")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:PrivateEndpointConnectionController lpmzrxdxhivwalyhlkjtl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/privateEndpointConnections/{peConnectionName}
 * ```
 * @property peConnectionName  Private link resource name.
 * @property privateLinkServiceConnectionState private endpoints connection state
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 */
public data class PrivateEndpointConnectionControllerArgs(
    public val peConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.PrivateEndpointConnectionControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.PrivateEndpointConnectionControllerArgs =
        com.pulumi.azurenative.offazure.PrivateEndpointConnectionControllerArgs.builder()
            .peConnectionName(peConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionControllerArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionControllerArgsBuilder internal constructor() {
    private var peConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    /**
     * @param value  Private link resource name.
     */
    @JvmName("fnxtfevbhjyljdqy")
    public suspend fun peConnectionName(`value`: Output<String>) {
        this.peConnectionName = value
    }

    /**
     * @param value private endpoints connection state
     */
    @JvmName("yqcgpylujjuicilp")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("okhcvnehpyxnxjpa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Site name
     */
    @JvmName("kwfiapxihipyqolj")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value  Private link resource name.
     */
    @JvmName("jfojcbvynlxwlbnq")
    public suspend fun peConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peConnectionName = mapped
    }

    /**
     * @param value private endpoints connection state
     */
    @JvmName("uytetxkhpregsqiu")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument private endpoints connection state
     */
    @JvmName("rguhvcoitxmhoqym")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("unwtfcekcodlgmyg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("yxxlsxyhfowwwskm")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    internal fun build(): PrivateEndpointConnectionControllerArgs =
        PrivateEndpointConnectionControllerArgs(
            peConnectionName = peConnectionName,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            resourceGroupName = resourceGroupName,
            siteName = siteName,
        )
}
