@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlDiscoverySiteDataSourceController].
 */
@PulumiTagMarker
public class SqlDiscoverySiteDataSourceControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlDiscoverySiteDataSourceControllerArgs =
        SqlDiscoverySiteDataSourceControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend SqlDiscoverySiteDataSourceControllerArgsBuilder.() -> Unit) {
        val builder = SqlDiscoverySiteDataSourceControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlDiscoverySiteDataSourceController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlDiscoverySiteDataSourceController(builtJavaResource)
    }
}

/**
 * A SQL discovery site data source resource.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### SqlDiscoverySiteDataSourceController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDiscoverySiteDataSourceController = new AzureNative.OffAzure.SqlDiscoverySiteDataSourceController("sqlDiscoverySiteDataSourceController", new()
 *     {
 *         DiscoverySiteDataSourceName = "q3--4O9O5vc-2",
 *         DiscoverySiteId = "xvtylcidvhdspuw",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "qU5b-1JBE45EC6Z-IF",
 *         SqlSiteName = "I5-O3912-L3y2Q57",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSqlDiscoverySiteDataSourceController(ctx, "sqlDiscoverySiteDataSourceController", &offazure.SqlDiscoverySiteDataSourceControllerArgs{
 * 			DiscoverySiteDataSourceName: pulumi.String("q3--4O9O5vc-2"),
 * 			DiscoverySiteId:             pulumi.String("xvtylcidvhdspuw"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("qU5b-1JBE45EC6Z-IF"),
 * 			SqlSiteName:                 pulumi.String("I5-O3912-L3y2Q57"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceController;
 * import com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDiscoverySiteDataSourceController = new SqlDiscoverySiteDataSourceController("sqlDiscoverySiteDataSourceController", SqlDiscoverySiteDataSourceControllerArgs.builder()
 *             .discoverySiteDataSourceName("q3--4O9O5vc-2")
 *             .discoverySiteId("xvtylcidvhdspuw")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("qU5b-1JBE45EC6Z-IF")
 *             .sqlSiteName("I5-O3912-L3y2Q57")
 *             .build());
 *     }
 * }
 * ```
 * ### SqlDiscoverySiteDataSourceController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlDiscoverySiteDataSourceController = new AzureNative.OffAzure.SqlDiscoverySiteDataSourceController("sqlDiscoverySiteDataSourceController", new()
 *     {
 *         DiscoverySiteDataSourceName = "Sw-cch",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "-2n-j-5O",
 *         SqlSiteName = "32F0K64",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSqlDiscoverySiteDataSourceController(ctx, "sqlDiscoverySiteDataSourceController", &offazure.SqlDiscoverySiteDataSourceControllerArgs{
 * 			DiscoverySiteDataSourceName: pulumi.String("Sw-cch"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("-2n-j-5O"),
 * 			SqlSiteName:                 pulumi.String("32F0K64"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceController;
 * import com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlDiscoverySiteDataSourceController = new SqlDiscoverySiteDataSourceController("sqlDiscoverySiteDataSourceController", SqlDiscoverySiteDataSourceControllerArgs.builder()
 *             .discoverySiteDataSourceName("Sw-cch")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("-2n-j-5O")
 *             .sqlSiteName("32F0K64")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:SqlDiscoverySiteDataSourceController aasatr /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/sqlSites/{sqlSiteName}/discoverySiteDataSources/{discoverySiteDataSourceName}
 * ```
 */
public class SqlDiscoverySiteDataSourceController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceController,
) : KotlinCustomResource(javaResource, SqlDiscoverySiteDataSourceControllerMapper) {
    /**
     * Gets or sets the discovery site Id.
     */
    public val discoverySiteId: Output<String>?
        get() = javaResource.discoverySiteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * provisioning state enum
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlDiscoverySiteDataSourceControllerMapper :
    ResourceMapper<SqlDiscoverySiteDataSourceController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceController::class == javaResource::class

    override fun map(javaResource: Resource): SqlDiscoverySiteDataSourceController =
        SqlDiscoverySiteDataSourceController(
            javaResource as
                com.pulumi.azurenative.offazure.SqlDiscoverySiteDataSourceController,
        )
}

/**
 * @see [SqlDiscoverySiteDataSourceController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlDiscoverySiteDataSourceController].
 */
public suspend fun sqlDiscoverySiteDataSourceController(
    name: String,
    block: suspend SqlDiscoverySiteDataSourceControllerResourceBuilder.() -> Unit,
):
    SqlDiscoverySiteDataSourceController {
    val builder = SqlDiscoverySiteDataSourceControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlDiscoverySiteDataSourceController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlDiscoverySiteDataSourceController(name: String):
    SqlDiscoverySiteDataSourceController {
    val builder = SqlDiscoverySiteDataSourceControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
