@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.SqlSitesControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.enums.SqlSitePropertiesDiscoveryScenario
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAppliancePropertiesArgs
import com.pulumi.azurenative.offazure.kotlin.inputs.SiteAppliancePropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SQL site web model.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### SqlSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlSitesController = new AzureNative.OffAzure.SqlSitesController("sqlSitesController", new()
 *     {
 *         DiscoveryScenario = AzureNative.OffAzure.SqlSitePropertiesDiscoveryScenario.Migrate,
 *         ResourceGroupName = "rgmigrate",
 *         SiteAppliancePropertiesCollection = new[]
 *         {
 *             new AzureNative.OffAzure.Inputs.SiteAppliancePropertiesArgs
 *             {
 *                 AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *                 {
 *                     KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *                     KeyVaultUri = "qizphgqwage",
 *                 },
 *                 ApplianceName = "zpbkpigahvexsxevwafzgsu",
 *                 ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *                 {
 *                     AadAuthority = "yanzipdww",
 *                     ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *                     Audience = "oepwfaozztzvegmzvswafvotj",
 *                     ObjectId = "tqrjngpgxnnto",
 *                     RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *                     TenantId = "vesmyhu",
 *                 },
 *             },
 *         },
 *         SiteName = "qo36fi7J8y-b",
 *         SqlSiteName = "A-4l5sbX5",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSqlSitesController(ctx, "sqlSitesController", &offazure.SqlSitesControllerArgs{
 * 			DiscoveryScenario: pulumi.String(offazure.SqlSitePropertiesDiscoveryScenarioMigrate),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteAppliancePropertiesCollection: offazure.SiteAppliancePropertiesArray{
 * 				&offazure.SiteAppliancePropertiesArgs{
 * 					AgentDetails: &offazure.SiteAgentPropertiesArgs{
 * 						KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 						KeyVaultUri: pulumi.String("qizphgqwage"),
 * 					},
 * 					ApplianceName: pulumi.String("zpbkpigahvexsxevwafzgsu"),
 * 					ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 						AadAuthority:  pulumi.String("yanzipdww"),
 * 						ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 						Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 						ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 						RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 						TenantId:      pulumi.String("vesmyhu"),
 * 					},
 * 				},
 * 			},
 * 			SiteName:    pulumi.String("qo36fi7J8y-b"),
 * 			SqlSiteName: pulumi.String("A-4l5sbX5"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SqlSitesController;
 * import com.pulumi.azurenative.offazure.SqlSitesControllerArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteAppliancePropertiesArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteAgentPropertiesArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlSitesController = new SqlSitesController("sqlSitesController", SqlSitesControllerArgs.builder()
 *             .discoveryScenario("Migrate")
 *             .resourceGroupName("rgmigrate")
 *             .siteAppliancePropertiesCollection(SiteAppliancePropertiesArgs.builder()
 *                 .agentDetails(SiteAgentPropertiesArgs.builder()
 *                     .keyVaultId("awxurtbjmofxuciewsqfgpkccpzw")
 *                     .keyVaultUri("qizphgqwage")
 *                     .build())
 *                 .applianceName("zpbkpigahvexsxevwafzgsu")
 *                 .servicePrincipalIdentityDetails(SiteSpnPropertiesArgs.builder()
 *                     .aadAuthority("yanzipdww")
 *                     .applicationId("tspgrujepxyxuprkqvfuqbbjrweeqa")
 *                     .audience("oepwfaozztzvegmzvswafvotj")
 *                     .objectId("tqrjngpgxnnto")
 *                     .rawCertData("dotvgkslkmsgvtekgojnhcdrryk")
 *                     .tenantId("vesmyhu")
 *                     .build())
 *                 .build())
 *             .siteName("qo36fi7J8y-b")
 *             .sqlSiteName("A-4l5sbX5")
 *             .build());
 *     }
 * }
 * ```
 * ### SqlSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlSitesController = new AzureNative.OffAzure.SqlSitesController("sqlSitesController", new()
 *     {
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "Ag5-Ex4n7G5Qn-5-yHL5",
 *         SqlSiteName = "-03--VkVPfDq5",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSqlSitesController(ctx, "sqlSitesController", &offazure.SqlSitesControllerArgs{
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("Ag5-Ex4n7G5Qn-5-yHL5"),
 * 			SqlSiteName:       pulumi.String("-03--VkVPfDq5"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SqlSitesController;
 * import com.pulumi.azurenative.offazure.SqlSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlSitesController = new SqlSitesController("sqlSitesController", SqlSitesControllerArgs.builder()
 *             .resourceGroupName("rgmigrate")
 *             .siteName("Ag5-Ex4n7G5Qn-5-yHL5")
 *             .sqlSiteName("-03--VkVPfDq5")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:SqlSitesController kfcekxrevjpsqnaphpqrwnwonqycgl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/sqlSites/{sqlSiteName}
 * ```
 * @property discoveryScenario Gets or sets the discovery scenario.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteAppliancePropertiesCollection Gets or sets the appliance details used by service to communicate
 * to the appliance.
 * @property siteName Site name
 * @property sqlSiteName SQL site name.
 */
public data class SqlSitesControllerArgs(
    public val discoveryScenario: Output<Either<String, SqlSitePropertiesDiscoveryScenario>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteAppliancePropertiesCollection: Output<List<SiteAppliancePropertiesArgs>>? = null,
    public val siteName: Output<String>? = null,
    public val sqlSiteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.SqlSitesControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.SqlSitesControllerArgs =
        com.pulumi.azurenative.offazure.SqlSitesControllerArgs.builder()
            .discoveryScenario(
                discoveryScenario?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteAppliancePropertiesCollection(
                siteAppliancePropertiesCollection?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .sqlSiteName(sqlSiteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlSitesControllerArgs].
 */
@PulumiTagMarker
public class SqlSitesControllerArgsBuilder internal constructor() {
    private var discoveryScenario: Output<Either<String, SqlSitePropertiesDiscoveryScenario>>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteAppliancePropertiesCollection: Output<List<SiteAppliancePropertiesArgs>>? = null

    private var siteName: Output<String>? = null

    private var sqlSiteName: Output<String>? = null

    /**
     * @param value Gets or sets the discovery scenario.
     */
    @JvmName("wkksxnwkbrwvgnyq")
    public suspend
    fun discoveryScenario(`value`: Output<Either<String, SqlSitePropertiesDiscoveryScenario>>) {
        this.discoveryScenario = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ptwxdkgjfmyxjakn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("gpqugbhwdxhbkvhq")
    public suspend
    fun siteAppliancePropertiesCollection(`value`: Output<List<SiteAppliancePropertiesArgs>>) {
        this.siteAppliancePropertiesCollection = value
    }

    @JvmName("mlhoxqffnhvxgavr")
    public suspend fun siteAppliancePropertiesCollection(
        vararg
        values: Output<SiteAppliancePropertiesArgs>,
    ) {
        this.siteAppliancePropertiesCollection = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("uqcrblfxjsnfyksj")
    public suspend
    fun siteAppliancePropertiesCollection(values: List<Output<SiteAppliancePropertiesArgs>>) {
        this.siteAppliancePropertiesCollection = Output.all(values)
    }

    /**
     * @param value Site name
     */
    @JvmName("tesqwioedvprwtvc")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value SQL site name.
     */
    @JvmName("awjnubiwpawcdhgr")
    public suspend fun sqlSiteName(`value`: Output<String>) {
        this.sqlSiteName = value
    }

    /**
     * @param value Gets or sets the discovery scenario.
     */
    @JvmName("ywqyebdyfgpgvtia")
    public suspend
    fun discoveryScenario(`value`: Either<String, SqlSitePropertiesDiscoveryScenario>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoveryScenario = mapped
    }

    /**
     * @param value Gets or sets the discovery scenario.
     */
    @JvmName("rkrpoovsgfaypkeh")
    public fun discoveryScenario(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlSitePropertiesDiscoveryScenario>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.discoveryScenario = mapped
    }

    /**
     * @param value Gets or sets the discovery scenario.
     */
    @JvmName("mxrjxqtuaftlvuih")
    public fun discoveryScenario(`value`: SqlSitePropertiesDiscoveryScenario) {
        val toBeMapped = Either.ofRight<String, SqlSitePropertiesDiscoveryScenario>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.discoveryScenario = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ksgiwmsdpndxvnwa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("cmuqodibhawfhbrc")
    public suspend
    fun siteAppliancePropertiesCollection(`value`: List<SiteAppliancePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param argument Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("bnlxvccvrfindlkp")
    public suspend
    fun siteAppliancePropertiesCollection(argument: List<suspend SiteAppliancePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SiteAppliancePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param argument Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("wrjmysyucanaipgc")
    public suspend fun siteAppliancePropertiesCollection(
        vararg
        argument: suspend SiteAppliancePropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SiteAppliancePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param argument Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("pqnlmdvsbhwqbnjw")
    public suspend
    fun siteAppliancePropertiesCollection(argument: suspend SiteAppliancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SiteAppliancePropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param values Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    @JvmName("agwatsqpwwbwcjbk")
    public suspend fun siteAppliancePropertiesCollection(vararg values: SiteAppliancePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.siteAppliancePropertiesCollection = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("chadjdxgutglmwkr")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value SQL site name.
     */
    @JvmName("sertvrwiaypjbekg")
    public suspend fun sqlSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlSiteName = mapped
    }

    internal fun build(): SqlSitesControllerArgs = SqlSitesControllerArgs(
        discoveryScenario = discoveryScenario,
        resourceGroupName = resourceGroupName,
        siteAppliancePropertiesCollection = siteAppliancePropertiesCollection,
        siteName = siteName,
        sqlSiteName = sqlSiteName,
    )
}
