@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.HealthErrorDetailsResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.offazure.kotlin.outputs.HealthErrorDetailsResponse.Companion.toKotlin as healthErrorDetailsResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [VcenterController].
 */
@PulumiTagMarker
public class VcenterControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VcenterControllerArgs = VcenterControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VcenterControllerArgsBuilder.() -> Unit) {
        val builder = VcenterControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VcenterController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.VcenterController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VcenterController(builtJavaResource)
    }
}

/**
 * A vcenter resource belonging to a site resource.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### VcenterController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vcenterController = new AzureNative.OffAzure.VcenterController("vcenterController", new()
 *     {
 *         Fqdn = "mzrejobgzhpxhynsfpumuhk",
 *         FriendlyName = "qqsnhutpvockzhwuesuohnfirvxmw",
 *         Port = "ahagklwzutlumcdhawkrfzmpfypcz",
 *         ProvisioningState = AzureNative.OffAzure.ProvisioningState.Created,
 *         ResourceGroupName = "rgmigrate",
 *         RunAsAccountId = "orrfsvlcuoagqlkkqsd",
 *         SiteName = "Snu-38v6",
 *         VcenterName = "e72lZRSD",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewVcenterController(ctx, "vcenterController", &offazure.VcenterControllerArgs{
 * 			Fqdn:              pulumi.String("mzrejobgzhpxhynsfpumuhk"),
 * 			FriendlyName:      pulumi.String("qqsnhutpvockzhwuesuohnfirvxmw"),
 * 			Port:              pulumi.String("ahagklwzutlumcdhawkrfzmpfypcz"),
 * 			ProvisioningState: pulumi.String(offazure.ProvisioningStateCreated),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			RunAsAccountId:    pulumi.String("orrfsvlcuoagqlkkqsd"),
 * 			SiteName:          pulumi.String("Snu-38v6"),
 * 			VcenterName:       pulumi.String("e72lZRSD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.VcenterController;
 * import com.pulumi.azurenative.offazure.VcenterControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vcenterController = new VcenterController("vcenterController", VcenterControllerArgs.builder()
 *             .fqdn("mzrejobgzhpxhynsfpumuhk")
 *             .friendlyName("qqsnhutpvockzhwuesuohnfirvxmw")
 *             .port("ahagklwzutlumcdhawkrfzmpfypcz")
 *             .provisioningState("Created")
 *             .resourceGroupName("rgmigrate")
 *             .runAsAccountId("orrfsvlcuoagqlkkqsd")
 *             .siteName("Snu-38v6")
 *             .vcenterName("e72lZRSD")
 *             .build());
 *     }
 * }
 * ```
 * ### VcenterController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vcenterController = new AzureNative.OffAzure.VcenterController("vcenterController", new()
 *     {
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "6-qSc554IYc4U08",
 *         VcenterName = "R5I8Xj8--zsS6JYI-0FNhe",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewVcenterController(ctx, "vcenterController", &offazure.VcenterControllerArgs{
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("6-qSc554IYc4U08"),
 * 			VcenterName:       pulumi.String("R5I8Xj8--zsS6JYI-0FNhe"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.VcenterController;
 * import com.pulumi.azurenative.offazure.VcenterControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vcenterController = new VcenterController("vcenterController", VcenterControllerArgs.builder()
 *             .resourceGroupName("rgmigrate")
 *             .siteName("6-qSc554IYc4U08")
 *             .vcenterName("R5I8Xj8--zsS6JYI-0FNhe")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:VcenterController vznkdfjpbb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/vmwareSites/{siteName}/vcenters/{vcenterName}
 * ```
 */
public class VcenterController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.VcenterController,
) : KotlinCustomResource(javaResource, VcenterControllerMapper) {
    /**
     * Gets the timestamp marking vCenter creation.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the errors.
     */
    public val errors: Output<List<HealthErrorDetailsResponse>>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    healthErrorDetailsResponseToKotlin(args0)
                })
            })
        })

    /**
     * Gets or sets the FQDN/IPAddress of the vCenter.
     */
    public val fqdn: Output<String>?
        get() = javaResource.fqdn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the friendly name of the vCenter.
     */
    public val friendlyName: Output<String>?
        get() = javaResource.friendlyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the instance UUID of the vCenter.
     */
    public val instanceUuid: Output<String>
        get() = javaResource.instanceUuid().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the performance statistics enabled on the vCenter.
     */
    public val perfStatisticsLevel: Output<String>
        get() = javaResource.perfStatisticsLevel().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the port of the vCenter.
     */
    public val port: Output<String>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the run as account ID of the vCenter.
     */
    public val runAsAccountId: Output<String>?
        get() = javaResource.runAsAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets the timestamp marking last updated on the vCenter.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the version of the vCenter.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object VcenterControllerMapper : ResourceMapper<VcenterController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.VcenterController::class == javaResource::class

    override fun map(javaResource: Resource): VcenterController = VcenterController(
        javaResource as
            com.pulumi.azurenative.offazure.VcenterController,
    )
}

/**
 * @see [VcenterController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VcenterController].
 */
public suspend fun vcenterController(
    name: String,
    block: suspend VcenterControllerResourceBuilder.() -> Unit,
): VcenterController {
    val builder = VcenterControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VcenterController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vcenterController(name: String): VcenterController {
    val builder = VcenterControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
